/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.util;

import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.bmotionstudio.gef.editor.Animation;
import de.bmotionstudio.gef.editor.model.BControl;
import de.prob.core.Animator;
import de.prob.core.command.EvaluationGetValuesCommand;
import de.prob.core.command.GetOperationByPredicateCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.EvaluationStateElement;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.parserbase.ProBParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BMSUtil {
    private static final Pattern PATTERN = Pattern.compile("\\$(.+?)\\$");
    private static final String DEFAULT_PREDICATE = "1=1";
    private static final String DEFAULT_BOOLVAL = "true";

    public static String parseExpression(String expressionString, BControl control, Animation animation) {
        return BMSUtil.parseExpression(expressionString, control, animation, false, true);
    }

    public static String parseExpression(String expressionString, BControl control, Animation animation, boolean parseControls) {
        return BMSUtil.parseExpression(expressionString, control, animation, false, parseControls);
    }

    public static String parsePredicate(String expressionString, BControl control, Animation animation) {
        return BMSUtil.parsePredicate(expressionString, control, animation, true);
    }

    public static String parsePredicate(String expressionString, BControl control, Animation animation, boolean parseControls) {
        if (expressionString == null || expressionString.trim().length() == 0) {
            return DEFAULT_BOOLVAL;
        }
        return BMSUtil.parseExpression(expressionString, control, animation, true, parseControls);
    }

    private static String parseExpression(String expressionString, BControl control, Animation animation, boolean isPredicate, boolean parseControls) {
        Collection<Object> resultList;
        boolean hasError = false;
        boolean hasSubExpressions = false;
        HashMap<EvaluationElement, String> evaluationKeys = new HashMap<EvaluationElement, String>();
        Matcher matcher = PATTERN.matcher(expressionString);
        while (matcher.find()) {
            String subExpr = matcher.group(1);
            BMSUtil.collectEvalElements(subExpr, "$" + subExpr + "$", isPredicate, animation, control, evaluationKeys, parseControls);
            hasSubExpressions = true;
        }
        if (!hasSubExpressions) {
            BMSUtil.collectEvalElements(expressionString, expressionString, isPredicate, animation, control, evaluationKeys, parseControls);
        }
        try {
            resultList = BMSUtil.getExpressionValues(control, animation, new ArrayList<EvaluationElement>(evaluationKeys.keySet()));
        }
        catch (ProBException proBException) {
            resultList = Collections.emptyList();
            hasError = true;
        }
        String result = expressionString;
        if (!hasError) {
            for (EvaluationStateElement evaluationStateElement : resultList) {
                EvaluationElement evalElement = evaluationStateElement.getElement();
                String text = isPredicate ? (evaluationStateElement.getResult().isPredicateTrue() ? DEFAULT_BOOLVAL : "false") : evaluationStateElement.getText();
                String subExpression = (String)evaluationKeys.get(evalElement);
                result = result.replace(subExpression, text);
            }
        }
        return result;
    }

    private static boolean collectEvalElements(String subexpression, String key, boolean isPredicate, Animation animation, BControl control, Map<EvaluationElement, String> evaluationKeys, boolean parseControls) {
        String parsedSubexpr = subexpression;
        if (parseControls) {
            parsedSubexpr = BMSUtil.parseControls(parsedSubexpr, control);
        }
        try {
            EvaluationElement evalElement = animation.getCachedEvalElement(parsedSubexpr, isPredicate);
            evaluationKeys.put(evalElement, key);
            return true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        catch (ProBException proBException) {
            return false;
        }
        catch (ProBParseException proBParseException) {
            return false;
        }
    }

    public static String parseControls(String expressionString, BControl control) {
        List<String> allControlIDs = control.getVisualization().getAllBControlNames();
        Pattern cPattern = Pattern.compile("(\\w+)");
        Matcher cMatcher = cPattern.matcher(expressionString);
        while (cMatcher.find()) {
            String controlID = cMatcher.group(1);
            if (controlID.equals("this")) {
                expressionString = expressionString.replace(controlID, control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeCustom").toString());
                continue;
            }
            if (!allControlIDs.contains(controlID)) continue;
            expressionString = expressionString.replace(controlID, control.getVisualization().getBControl(controlID).getValueOfData());
        }
        return expressionString;
    }

    private static Collection<EvaluationStateElement> getExpressionValues(BControl control, Animation animation, Collection<EvaluationElement> evalElements) throws ProBException {
        State state = animation.getAnimator().getCurrentState();
        Collection values = EvaluationGetValuesCommand.getValuesForExpressionsCached((State)state, evalElements);
        return values;
    }

    public static List<Operation> parseOperation(String opName, String opPredicate, int opRandom, Animation animation, String currentState, BControl control) {
        try {
            opPredicate = opPredicate != null && opPredicate.length() > 0 ? BMSUtil.parseControls(opPredicate, control) : DEFAULT_PREDICATE;
            if (opRandom < 1) {
                opRandom = 1;
            }
            return GetOperationByPredicateCommand.getOperations((Animator)animation.getAnimator(), (String)currentState, (String)opName, (String)opPredicate, (int)opRandom);
        }
        catch (ProBException proBException) {
        }
        catch (BCompoundException bCompoundException) {}
        return null;
    }
}

