/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler.wizard;

import de.bmotionstudio.gef.editor.BMotionAbstractWizard;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.BindingObject;
import de.bmotionstudio.gef.editor.edit.OperationValueEditingSupport;
import de.bmotionstudio.gef.editor.edit.PredicateEditingSupport;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.property.IntegerCellEditor;
import de.bmotionstudio.gef.editor.scheduler.ExecuteOperationByPredicateMulti;
import de.bmotionstudio.gef.editor.scheduler.PredicateOperation;
import de.bmotionstudio.gef.editor.scheduler.SchedulerEvent;
import de.bmotionstudio.gef.editor.scheduler.SchedulerWizard;
import de.bmotionstudio.gef.editor.util.BMotionWizardUtil;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WizardExecuteOperationByPredicateMulti
extends SchedulerWizard {
    public WizardExecuteOperationByPredicateMulti(BControl bcontrol, SchedulerEvent scheduler) {
        super(bcontrol, scheduler);
        this.addPage((IWizardPage)new MultiPage("MultiPage"));
    }

    @Override
    protected Boolean prepareToFinish() {
        if (((ExecuteOperationByPredicateMulti)this.getScheduler()).getOperationList().size() == 0) {
            this.setEventDelete(true);
        } else {
            for (BindingObject obj : ((ExecuteOperationByPredicateMulti)this.getScheduler()).getOperationList()) {
                if (((PredicateOperation)obj).getOperationName() != null && !((PredicateOperation)obj).getOperationName().isEmpty()) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)"Please check your entries", (String)"Please check your entries. The operation field must not be empty.");
                return false;
            }
        }
        return true;
    }

    @Override
    public Point getSize() {
        return new Point(700, 500);
    }

    private class MultiPage
    extends WizardPage {
        private TableViewer tableViewer;

        protected MultiPage(String pageName) {
            super(pageName);
        }

        public void createControl(Composite parent) {
            DataBindingContext dbc = new DataBindingContext();
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, true));
            this.setControl((Control)container);
            this.tableViewer = BMotionWizardUtil.createBMotionWizardTableViewer(container, PredicateOperation.class, ((BMotionAbstractWizard)this.getWizard()).getName());
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Execute Rule");
            column.getColumn().setWidth(190);
            column.setEditingSupport((EditingSupport)new PredicateEditingSupport(this.tableViewer, dbc, "executePredicate", WizardExecuteOperationByPredicateMulti.this.getBControl().getVisualization(), this.getShell()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Operation");
            column.getColumn().setWidth(150);
            column.setEditingSupport((EditingSupport)new OperationValueEditingSupport(this.tableViewer, WizardExecuteOperationByPredicateMulti.this.getBControl()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Parameter");
            column.getColumn().setWidth(190);
            column.setEditingSupport((EditingSupport)new PredicateEditingSupport(this.tableViewer, dbc, "predicate", WizardExecuteOperationByPredicateMulti.this.getBControl().getVisualization(), this.getShell()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Random Ops");
            column.getColumn().setWidth(100);
            column.setEditingSupport((EditingSupport)new RandomModeEditingSupport((ColumnViewer)this.tableViewer));
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(new IObservableMap[]{BeanProperties.value(PredicateOperation.class, (String)"executePredicate").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(PredicateOperation.class, (String)"operationName").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(PredicateOperation.class, (String)"predicate").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(PredicateOperation.class, (String)"maxrandom").observeDetail(contentProvider.getKnownElements())}));
            final WritableList input = new WritableList(((ExecuteOperationByPredicateMulti)WizardExecuteOperationByPredicateMulti.this.getScheduler()).getOperationList(), PredicateOperation.class);
            this.tableViewer.setInput((Object)input);
            Composite comp = new Composite(container, 0);
            comp.setLayout((Layout)new RowLayout());
            comp.setLayoutData((Object)new GridData(128));
            Button btRemove = new Button(comp, 8);
            btRemove.setText("Remove");
            btRemove.setImage(BMotionStudioImage.getImage("icon_delete"));
            btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MultiPage.this.tableViewer.getSelection().isEmpty()) {
                        return;
                    }
                    PredicateOperation obj = (PredicateOperation)((IStructuredSelection)MultiPage.this.tableViewer.getSelection()).getFirstElement();
                    input.remove((Object)obj);
                }
            });
            Button btAdd = new Button(comp, 8);
            btAdd.setText("Add");
            btAdd.setImage(BMotionStudioImage.getImage("icon_add"));
            btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PredicateOperation obj = new PredicateOperation();
                    input.add((Object)obj);
                }
            });
        }
    }

    private static class RandomModeEditingSupport
    extends EditingSupport {
        private CellEditor cellEditor;

        public RandomModeEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                Integer maxnr = Integer.valueOf(value.toString());
                PredicateOperation obj = (PredicateOperation)element;
                obj.setMaxrandom(maxnr);
                if (maxnr > 1) {
                    obj.setRandom(true);
                } else {
                    obj.setRandom(false);
                }
            }
        }

        protected Object getValue(Object element) {
            return ((PredicateOperation)element).getMaxrandom();
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.cellEditor == null) {
                this.cellEditor = new IntegerCellEditor((Composite)this.getViewer().getControl());
            }
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

