/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.scheduler.wizard;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.edit.OperationValueEditingSupport;
import de.bmotionstudio.gef.editor.edit.PredicateEditingSupport;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.property.IntegerCellEditor;
import de.bmotionstudio.gef.editor.scheduler.AnimationScriptObject;
import de.bmotionstudio.gef.editor.scheduler.AnimationScriptStep;
import de.bmotionstudio.gef.editor.util.BMotionWizardUtil;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SchedulerObjectDialog
extends Dialog {
    private TableViewer tableViewer;
    private final BControl control;
    private AnimationScriptObject animationScriptObject;

    public SchedulerObjectDialog(Shell parentShell, BControl control, AnimationScriptObject animationScriptObject) {
        super(parentShell);
        this.control = control;
        this.animationScriptObject = animationScriptObject;
    }

    protected Control createDialogArea(Composite parent) {
        DataBindingContext dbc = new DataBindingContext();
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        this.tableViewer = BMotionWizardUtil.createBMotionWizardTableViewer(container, AnimationScriptStep.class, "Scheduler Object Dialog");
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText("Operation");
        column.getColumn().setWidth(175);
        column.setEditingSupport((EditingSupport)new OperationValueEditingSupport(this.tableViewer, this.control){

            @Override
            protected Object getValue(Object element) {
                return ((AnimationScriptStep)element).getCommand();
            }

            @Override
            protected void setValue(Object element, Object value) {
                if (value != null) {
                    ((AnimationScriptStep)element).setCommand(value.toString());
                }
            }
        });
        column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText("Predicate");
        column.getColumn().setWidth(300);
        column.setEditingSupport((EditingSupport)new PredicateEditingSupport(this.tableViewer, dbc, "parameter", this.control.getVisualization(), this.getShell()));
        column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText("Random Ops");
        column.getColumn().setWidth(100);
        column.setEditingSupport((EditingSupport)new RandomModeEditingSupport((ColumnViewer)this.tableViewer));
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(new IObservableMap[]{BeanProperties.value(AnimationScriptStep.class, (String)"command").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(AnimationScriptStep.class, (String)"parameter").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(AnimationScriptStep.class, (String)"maxrandom").observeDetail(contentProvider.getKnownElements())}){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        final WritableList input = new WritableList(this.animationScriptObject.getSteps(), AnimationScriptStep.class);
        this.tableViewer.setInput((Object)input);
        Composite comp = new Composite(container, 0);
        comp.setLayout((Layout)new RowLayout());
        comp.setLayoutData((Object)new GridData(128));
        Button btRemove = new Button(comp, 8);
        btRemove.setText("Remove");
        btRemove.setImage(BMotionStudioImage.getImage("icon_delete"));
        btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchedulerObjectDialog.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                AnimationScriptStep obj = (AnimationScriptStep)((IStructuredSelection)SchedulerObjectDialog.this.tableViewer.getSelection()).getFirstElement();
                input.remove((Object)obj);
            }
        });
        Button btAdd = new Button(comp, 8);
        btAdd.setText("Add");
        btAdd.setImage(BMotionStudioImage.getImage("icon_add"));
        btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnimationScriptStep obj = new AnimationScriptStep();
                input.add((Object)obj);
            }
        });
        return container;
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    protected void okPressed() {
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("BMotion Studio - Scheduler Editor");
    }

    public void setAnimationScriptObject(AnimationScriptObject animationScriptObject) {
        this.animationScriptObject = animationScriptObject;
    }

    public AnimationScriptObject getAnimationScriptObject() {
        return this.animationScriptObject;
    }

    private static class RandomModeEditingSupport
    extends EditingSupport {
        private CellEditor cellEditor;

        public RandomModeEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                Integer maxnr = Integer.valueOf(value.toString());
                AnimationScriptStep obj = (AnimationScriptStep)element;
                obj.setMaxrandom(maxnr);
            }
        }

        protected Object getValue(Object element) {
            return ((AnimationScriptStep)element).getMaxrandom();
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.cellEditor == null) {
                this.cellEditor = new IntegerCellEditor((Composite)this.getViewer().getControl());
            }
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

