/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.property;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.library.LibraryImageObject;
import de.bmotionstudio.gef.editor.library.LibraryObject;
import de.bmotionstudio.gef.editor.property.ImageDialogCellEditor;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImageDialog
extends Dialog {
    private TableViewer tvLibrary;
    private Image previewImage;
    private Composite preContainer;
    private Canvas previewCanvas;
    private final ImageDialogCellEditor imageDialogCellEditor;

    protected ImageDialog(Shell parentShell, ImageDialogCellEditor imageDialogCellEditor) {
        super(parentShell);
        this.imageDialogCellEditor = imageDialogCellEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        container.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 0;
        this.preContainer = new Composite(container, 0);
        this.preContainer.setLayoutData((Object)gd);
        this.preContainer.setLayout((Layout)new FillLayout());
        this.previewCanvas = new Canvas(this.preContainer, 2048);
        this.previewCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageDialog.this.previewImage == null) {
                    e.gc.drawString("No image selected ...", 0, 0);
                } else {
                    e.gc.drawImage(ImageDialog.this.previewImage, 0, 0);
                }
            }
        });
        Composite libContainer = new Composite(container, 0);
        libContainer.setLayoutData((Object)gd);
        libContainer.setLayout((Layout)new FillLayout());
        this.tvLibrary = new TableViewer(libContainer, 66048);
        this.tvLibrary.getTable().setLayoutData((Object)gd);
        this.tvLibrary.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IFile pFile;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LibraryObject obj = (LibraryObject)selection.getFirstElement();
                if (ImageDialog.this.previewImage != null) {
                    ImageDialog.this.previewImage.dispose();
                }
                ImageDialog.this.previewImage = null;
                if (obj != null && !obj.getName().equals("noimage") && (pFile = BMotionEditorPlugin.getActiveEditor().getVisualization().getProjectFile()) != null) {
                    String myPath = (String.valueOf(pFile.getProject().getLocationURI()) + "/images/" + obj.getName()).replace("file:", "");
                    ImageDialog.this.previewImage = new Image((Device)Display.getDefault(), myPath);
                }
                ImageDialog.this.previewCanvas.redraw();
            }
        });
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tvLibrary.setContentProvider((IContentProvider)contentProvider);
        this.tvLibrary.getTable().setLinesVisible(true);
        this.tvLibrary.getTable().setHeaderVisible(true);
        TableViewerColumn column1 = new TableViewerColumn(this.tvLibrary, 0);
        column1.getColumn().setText("Name");
        column1.getColumn().setWidth(390);
        column1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((LibraryObject)cell.getElement()).getName());
                cell.setImage(((LibraryObject)cell.getElement()).getImage());
            }
        });
        TableViewerColumn column2 = new TableViewerColumn(this.tvLibrary, 0);
        column2.getColumn().setText("Type");
        column2.getColumn().setWidth(60);
        column2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((LibraryObject)cell.getElement()).getType());
            }
        });
        WritableList input = new WritableList(this.getLibraryObjects(), LibraryObject.class);
        this.tvLibrary.setInput((Object)input);
        return container;
    }

    private List<LibraryObject> getLibraryObjects() {
        String basePath;
        File dir;
        File[] fileList;
        ArrayList<LibraryObject> tmpList = new ArrayList<LibraryObject>();
        tmpList.add(new LibraryObject("noimage", "", BMotionStudioImage.getImageDescriptor("org.eclipse.ui", "$nl$/icons/full/etool16/delete_edit.gif").createImage()));
        if (BMotionEditorPlugin.getActiveEditor() != null && (fileList = (dir = new File((basePath = BMotionEditorPlugin.getActiveEditor().getVisualization().getProjectFile().getProject().getLocation().toString().replace("file:", "")) + "/images")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png");
            }
        })) != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Image img = null;
                img = f.getName().toLowerCase().endsWith(".jpg") ? BMotionStudioImage.getImage("icon_jpg") : BMotionStudioImage.getImage("icon_gif");
                tmpList.add(new LibraryImageObject(f.getName(), "image", img));
                ++n2;
            }
        }
        return tmpList;
    }

    LibraryObject getSelectedObject() {
        IStructuredSelection sel = (IStructuredSelection)this.tvLibrary.getSelection();
        LibraryObject lobj = (LibraryObject)sel.getFirstElement();
        return lobj;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected void okPressed() {
        LibraryObject sel = this.getSelectedObject();
        if (sel != null) {
            if (!sel.getName().equals("noimage")) {
                this.imageDialogCellEditor.setValue(sel.getName());
            } else {
                this.imageDialogCellEditor.setValue("");
            }
        }
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("BMotion Studio - Select image dialog");
    }
}

