/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.command.ConnectionDeleteCommand;
import de.bmotionstudio.gef.editor.model.Track;
import de.bmotionstudio.gef.editor.part.BConnectionEditPart;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class TrackPart
extends BConnectionEditPart {
    @Override
    protected void prepareEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new ConnectionDeleteCommand((Track)TrackPart.this.getModel());
            }
        });
    }

    @Override
    protected ConnectionAnchor getSourceConnectionAnchor() {
        if (this.getSource() != null) {
            IFigure f = ((GraphicalEditPart)this.getSource()).getFigure();
            return new ChopboxAnchor(f){

                public Point getLocation(Point reference) {
                    Rectangle r = Rectangle.SINGLETON;
                    r.setBounds(this.getBox());
                    r.translate(-1, -1);
                    r.resize(1, 1);
                    this.getOwner().translateToAbsolute((Translatable)r);
                    float centerX = (float)r.x + 0.5f * (float)r.width;
                    float centerY = (float)r.y + 0.5f * (float)r.height;
                    if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
                        return new Point((int)centerX, (int)centerY);
                    }
                    return new Point(Math.round(centerX), Math.round(centerY));
                }
            };
        }
        return DEFAULT_SOURCE_ANCHOR;
    }

    @Override
    protected ConnectionAnchor getTargetConnectionAnchor() {
        if (this.getTarget() != null) {
            IFigure f = ((GraphicalEditPart)this.getTarget()).getFigure();
            return new ChopboxAnchor(f){

                public Point getLocation(Point reference) {
                    Rectangle r = Rectangle.SINGLETON;
                    r.setBounds(this.getBox());
                    r.translate(-1, -1);
                    r.resize(1, 1);
                    this.getOwner().translateToAbsolute((Translatable)r);
                    float centerX = (float)r.x + 0.5f * (float)r.width;
                    float centerY = (float)r.y + 0.5f * (float)r.height;
                    if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
                        return new Point((int)centerX, (int)centerY);
                    }
                    return new Point(Math.round(centerX), Math.round(centerY));
                }
            };
        }
        return DEFAULT_TARGET_ANCHOR;
    }
}

