/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.command.CreateCommand;
import de.bmotionstudio.gef.editor.editpolicy.BMSConnectionEditPolicy;
import de.bmotionstudio.gef.editor.editpolicy.BMSDeletePolicy;
import de.bmotionstudio.gef.editor.editpolicy.SignalLayoutEditPolicy;
import de.bmotionstudio.gef.editor.figure.SignalFigure;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Light;
import de.bmotionstudio.gef.editor.part.BMSAbstractEditPart;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;

public class SignalPart
extends BMSAbstractEditPart {
    @Override
    protected IFigure createEditFigure() {
        return new SignalFigure();
    }

    @Override
    protected void refreshEditLayout(IFigure figure, BControl control) {
        int lights = Integer.valueOf(control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.AttributeLights").toString());
        figure.getParent().setConstraint(figure, (Object)new Rectangle(control.getLocation().x, control.getLocation().y, control.getDimension().width, lights * 12 + 30));
    }

    @Override
    public void refreshEditFigure(IFigure figure, BControl model, PropertyChangeEvent evt) {
        Object value = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        String aID = evt.getPropertyName();
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.AttributeLights")) {
            int i;
            if (oldValue == null || value.equals(oldValue)) {
                return;
            }
            Integer numberOfLights = Integer.valueOf(value.toString());
            Integer numberOfCurrentLights = Integer.valueOf(oldValue.toString());
            if (numberOfLights < numberOfCurrentLights) {
                i = numberOfCurrentLights - 1;
                while (i >= numberOfLights) {
                    model.removeChild(i);
                    --i;
                }
            }
            i = numberOfCurrentLights;
            while (i < numberOfLights) {
                Light light = new Light(model.getVisualization());
                CreateCommand cmd = new CreateCommand(light, model);
                cmd.execute();
                ++i;
            }
            this.refreshEditLayout(figure, model);
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeLabel")) {
            ((SignalFigure)this.getFigure()).setLabel(value.toString());
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.AttributeTrackDirection")) {
            int direction = Integer.valueOf(value.toString());
            if (direction == 1) {
                ((SignalFigure)this.getFigure()).setTrackDirection(false);
            } else {
                ((SignalFigure)this.getFigure()).setTrackDirection(true);
            }
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeVisible")) {
            ((SignalFigure)figure).setVisible(Boolean.valueOf(value.toString()));
        }
    }

    @Override
    protected void prepareEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SignalLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BMSDeletePolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new BMSConnectionEditPolicy());
    }

    @Override
    protected void prepareRunPolicies() {
    }

    @Override
    public List<BControl> getModelChildren() {
        return ((BControl)this.getModel()).getChildrenArray();
    }
}

