/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.command.CreateCommand;
import de.bmotionstudio.gef.editor.editpolicy.BMSConnectionEditPolicy;
import de.bmotionstudio.gef.editor.editpolicy.BMSDeletePolicy;
import de.bmotionstudio.gef.editor.editpolicy.TableLayoutEditPolicy;
import de.bmotionstudio.gef.editor.figure.TableFigure;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.BTableCell;
import de.bmotionstudio.gef.editor.model.BTableColumn;
import de.bmotionstudio.gef.editor.part.BMSAbstractEditPart;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

public class BTablePart
extends BMSAbstractEditPart {
    @Override
    protected IFigure createEditFigure() {
        TableFigure tableFigure = new TableFigure();
        Label figure = new Label();
        tableFigure.add((IFigure)figure);
        if (!this.isRunning().booleanValue()) {
            figure.setIcon(BMotionStudioImage.getImage("icon_tr_left"));
        }
        return tableFigure;
    }

    @Override
    protected void prepareEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TableLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BMSDeletePolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new BMSConnectionEditPolicy());
    }

    @Override
    protected void prepareRunPolicies() {
    }

    @Override
    protected void refreshEditLayout(IFigure figure, BControl control) {
        int width = 0;
        int rows = Integer.valueOf(control.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeRows").toString());
        for (BControl column : control.getChildrenArray()) {
            width += column.getLayout().width;
        }
        figure.getParent().setConstraint(figure, (Object)new Rectangle(control.getLocation().x, control.getLocation().y, width + 21, rows * 20 + 15));
    }

    @Override
    public void refreshEditFigure(IFigure figure, BControl model, PropertyChangeEvent evt) {
        Object value = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        String aID = evt.getPropertyName();
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeVisible")) {
            ((TableFigure)figure).setVisible(Boolean.valueOf(value.toString()));
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeForegroundColor")) {
            ((TableFigure)figure).setForegroundColor((RGB)value);
            for (BControl child : model.getChildrenArray()) {
                child.setAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeForegroundColor", value);
            }
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeColumns")) {
            int i;
            if (oldValue == null || value.equals(oldValue)) {
                return;
            }
            Integer numberOfColumns = Integer.valueOf(value.toString());
            Integer numberOfCurrentColumns = Integer.valueOf(oldValue.toString());
            if (numberOfColumns < numberOfCurrentColumns) {
                i = numberOfCurrentColumns - 1;
                while (i >= numberOfColumns) {
                    model.removeChild(i);
                    --i;
                }
            }
            i = numberOfCurrentColumns;
            while (i < numberOfColumns) {
                BTableColumn bTableColumn = new BTableColumn(model.getVisualization());
                CreateCommand cmd = new CreateCommand(bTableColumn, model);
                cmd.execute();
                Integer numberOfRows = Integer.valueOf(model.getAttributeValue("de.bmotionstudio.gef.editor.attribute.BAttributeRows").toString());
                this.refreshRows(bTableColumn, numberOfRows);
                ++i;
            }
            this.refreshEditLayout(figure, model);
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeRows")) {
            if (oldValue == null || value.equals(oldValue)) {
                return;
            }
            Integer numberOfRows = Integer.valueOf(value.toString());
            List<BControl> columnChildren = model.getChildrenArray();
            for (BControl column : columnChildren) {
                this.refreshRows(column, numberOfRows);
            }
            this.refreshEditLayout(figure, model);
        }
    }

    private void refreshRows(BControl column, int numberOfRows) {
        int i;
        Integer numberOfCurrentRows = column.getChildrenArray().size();
        if (numberOfRows < numberOfCurrentRows) {
            i = numberOfCurrentRows - 1;
            while (i >= numberOfRows) {
                column.removeChild(i);
                --i;
            }
        }
        i = numberOfCurrentRows;
        while (i < numberOfRows) {
            CreateCommand cmd = new CreateCommand(new BTableCell(column.getVisualization()), column);
            cmd.setLayout(new Rectangle(0, 0, column.getDimension().width, 20));
            cmd.execute();
            ++i;
        }
    }

    @Override
    public List<BControl> getModelChildren() {
        return ((BControl)this.getModel()).getChildrenArray();
    }
}

