/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.part;

import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.attribute.BAttributeConnectionSourceDecoration;
import de.bmotionstudio.gef.editor.command.ConnectionDeleteCommand;
import de.bmotionstudio.gef.editor.model.BConnection;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.part.BMSAbstractEditPart;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class BConnectionEditPart
extends BMSAbstractEditPart
implements ConnectionEditPart,
LayerConstants {
    protected Color foregroundColor;
    private Label conLabel;
    public static final ConnectionAnchor DEFAULT_SOURCE_ANCHOR = new XYAnchor(new Point(10, 10));
    public static final ConnectionAnchor DEFAULT_TARGET_ANCHOR = new XYAnchor(new Point(100, 100));
    private EditPart sourceEditPart;
    private EditPart targetEditPart;

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.isActive()) {
            this.foregroundColor.dispose();
        }
    }

    @Override
    protected void prepareEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new ConnectionDeleteCommand((BConnection)BConnectionEditPart.this.getModel());
            }
        });
    }

    @Override
    protected IFigure createEditFigure() {
        PolylineConnection connection = new PolylineConnection(){
            private boolean visible;

            public void paint(Graphics g) {
                if (!this.visible && !BConnectionEditPart.this.isRunning().booleanValue()) {
                    Rectangle clientArea = this.getClientArea();
                    g.drawImage(BMotionStudioImage.getImage("icon_control_hidden"), clientArea.x, clientArea.y);
                    g.setAlpha(35);
                }
                super.paint(g);
            }

            public void setVisible(boolean visible) {
                if (!BConnectionEditPart.this.isRunning().booleanValue()) {
                    this.visible = visible;
                    this.repaint();
                } else {
                    super.setVisible(visible);
                }
            }
        };
        this.conLabel = new Label();
        MidpointLocator locator = new MidpointLocator((Connection)connection, 0);
        locator.setRelativePosition(1);
        connection.add((IFigure)this.conLabel, (Object)locator);
        return connection;
    }

    @Override
    public void refreshEditFigure(IFigure figure, BControl model, PropertyChangeEvent evt) {
        int decoration;
        Object value = evt.getNewValue();
        String aID = evt.getPropertyName();
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeLineWidth")) {
            ((PolylineConnection)this.getFigure()).setLineWidth(Integer.valueOf(value.toString()).intValue());
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeLineStyle")) {
            ((PolylineConnection)this.getFigure()).setLineStyle(Integer.valueOf(value.toString()) + 1);
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeVisible")) {
            ((PolylineConnection)this.getFigure()).setVisible(Boolean.valueOf(value.toString()).booleanValue());
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeForegroundColor")) {
            if (this.foregroundColor != null) {
                this.foregroundColor.dispose();
            }
            this.foregroundColor = new Color((Device)Display.getDefault(), (RGB)value);
            ((PolylineConnection)this.getFigure()).setForegroundColor(this.foregroundColor);
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeConnectionSourceDecoration")) {
            decoration = Integer.valueOf(value.toString());
            if (decoration == BAttributeConnectionSourceDecoration.DECORATION_TRIANGLE) {
                ((PolylineConnection)this.getFigure()).setSourceDecoration((RotatableDecoration)new PolygonDecoration());
            } else {
                ((PolylineConnection)this.getFigure()).setSourceDecoration(null);
            }
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeConnectionTargetDecoration")) {
            decoration = Integer.valueOf(value.toString());
            if (decoration == BAttributeConnectionSourceDecoration.DECORATION_TRIANGLE) {
                ((PolylineConnection)this.getFigure()).setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            } else {
                ((PolylineConnection)this.getFigure()).setTargetDecoration(null);
            }
        }
        if (aID.equals("de.bmotionstudio.gef.editor.attribute.BAttributeLabel")) {
            this.conLabel.setText(value.toString());
        }
    }

    protected void activateFigure() {
        this.getLayer("Connection Layer").add(this.getFigure());
    }

    public void addNotify() {
        this.activateFigure();
        super.addNotify();
    }

    protected void deactivateFigure() {
        this.getLayer("Connection Layer").remove(this.getFigure());
        this.getConnectionFigure().setSourceAnchor(null);
        this.getConnectionFigure().setTargetAnchor(null);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AccessibleAnchorProvider.class) {
            return new DefaultAccessibleAnchorProvider();
        }
        return super.getAdapter(adapter);
    }

    public Connection getConnectionFigure() {
        return (Connection)this.getFigure();
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public EditPart getSource() {
        return this.sourceEditPart;
    }

    public EditPart getTarget() {
        return this.targetEditPart;
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        if (this.getSource() != null) {
            if (this.getSource() instanceof NodeEditPart) {
                NodeEditPart editPart = (NodeEditPart)this.getSource();
                return editPart.getSourceConnectionAnchor((ConnectionEditPart)this);
            }
            IFigure f = ((GraphicalEditPart)this.getSource()).getFigure();
            return new ChopboxAnchor(f);
        }
        return DEFAULT_SOURCE_ANCHOR;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        if (this.getTarget() != null) {
            if (this.getTarget() instanceof NodeEditPart) {
                NodeEditPart editPart = (NodeEditPart)this.getTarget();
                return editPart.getTargetConnectionAnchor((ConnectionEditPart)this);
            }
            IFigure f = ((GraphicalEditPart)this.getTarget()).getFigure();
            return new ChopboxAnchor(f);
        }
        return DEFAULT_TARGET_ANCHOR;
    }

    public void refresh() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refresh();
    }

    protected void refreshSourceAnchor() {
        this.getConnectionFigure().setSourceAnchor(this.getSourceConnectionAnchor());
    }

    protected void refreshTargetAnchor() {
        this.getConnectionFigure().setTargetAnchor(this.getTargetConnectionAnchor());
    }

    public void removeNotify() {
        this.deactivateFigure();
        super.removeNotify();
    }

    public void setParent(EditPart parent) {
        boolean becomingNull;
        boolean wasNull = this.getParent() == null;
        boolean bl = becomingNull = parent == null;
        if (becomingNull && !wasNull) {
            this.removeNotify();
        }
        super.setParent(parent);
        if (wasNull && !becomingNull) {
            this.addNotify();
        }
    }

    public void setSource(EditPart editPart) {
        if (this.sourceEditPart == editPart) {
            return;
        }
        this.sourceEditPart = editPart;
        if (this.sourceEditPart != null) {
            this.setParent((EditPart)this.sourceEditPart.getRoot());
        } else if (this.getTarget() == null) {
            this.setParent(null);
        }
        if (this.sourceEditPart != null && this.targetEditPart != null) {
            this.refresh();
        }
    }

    public void setTarget(EditPart editPart) {
        if (this.targetEditPart == editPart) {
            return;
        }
        this.targetEditPart = editPart;
        if (editPart != null) {
            this.setParent((EditPart)editPart.getRoot());
        } else if (this.getSource() == null) {
            this.setParent(null);
        }
        if (this.sourceEditPart != null && this.targetEditPart != null) {
            this.refresh();
        }
    }

    @Override
    protected void prepareRunPolicies() {
    }

    protected final class DefaultAccessibleAnchorProvider
    implements AccessibleAnchorProvider {
        DefaultAccessibleAnchorProvider() {
        }

        public List<Point> getSourceAnchorLocations() {
            ArrayList<Point> list = new ArrayList<Point>();
            if (BConnectionEditPart.this.getFigure() instanceof Connection) {
                Point p = ((Connection)BConnectionEditPart.this.getFigure()).getPoints().getMidpoint();
                BConnectionEditPart.this.getFigure().translateToAbsolute((Translatable)p);
                list.add(p);
            }
            return list;
        }

        public List<Point> getTargetAnchorLocations() {
            return this.getSourceAnchorLocations();
        }
    }
}

