/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.observer.wizard;

import de.bmotionstudio.gef.editor.BMotionAbstractWizard;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.edit.AttributeExpressionEdittingSupport;
import de.bmotionstudio.gef.editor.edit.IsExpressionModeEditingSupport;
import de.bmotionstudio.gef.editor.edit.PredicateEditingSupport;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverEvalObject;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.bmotionstudio.gef.editor.observer.SwitchImage;
import de.bmotionstudio.gef.editor.observer.ToggleObjectImage;
import de.bmotionstudio.gef.editor.observer.wizard.AbstractObserverWizardPage;
import de.bmotionstudio.gef.editor.property.CheckboxCellEditorHelper;
import de.bmotionstudio.gef.editor.util.BMotionWizardUtil;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WizardObserverSwitchImage
extends ObserverWizard {
    public WizardObserverSwitchImage(BControl bcontrol, Observer bobserver) {
        super(bcontrol, bobserver);
        this.addPage((IWizardPage)new ObserverSwitchImagePage("ObserverToggleImagePage"));
    }

    @Override
    protected Boolean prepareToFinish() {
        if (((SwitchImage)this.getObserver()).getToggleObjects().size() == 0) {
            this.setObserverDelete(true);
        } else {
            for (ToggleObjectImage obj : ((SwitchImage)this.getObserver()).getToggleObjects()) {
                if (!obj.getImage().isEmpty()) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)"Please check your entries", (String)"Please check your entries. The image field must not be empty.");
                return false;
            }
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    @Override
    public Point getSize() {
        return new Point(650, 500);
    }

    private static class ObserverLabelProvider
    extends ObservableMapLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private final Color errorColor = Display.getDefault().getSystemColor(29);

        public ObserverLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2) {
                return CheckboxCellEditorHelper.getCellEditorImage(((ToggleObjectImage)element).isExpressionMode());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 2) {
                return "";
            }
            return super.getColumnText(element, columnIndex);
        }

        public Color getBackground(Object element, int column) {
            ToggleObjectImage attributeObject = (ToggleObjectImage)element;
            if (attributeObject.hasError().booleanValue()) {
                return this.errorColor;
            }
            return null;
        }

        public Color getForeground(Object element, int column) {
            return null;
        }

        public Font getFont(Object element, int column) {
            return null;
        }
    }

    private class ObserverSwitchImagePage
    extends AbstractObserverWizardPage {
        private TableViewer tableViewer;

        protected ObserverSwitchImagePage(String pageName) {
            super(pageName, WizardObserverSwitchImage.this.getObserver());
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            DataBindingContext dbc = new DataBindingContext();
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, true));
            this.tableViewer = BMotionWizardUtil.createBMotionWizardTableViewer(container, ToggleObjectImage.class, ((BMotionAbstractWizard)this.getWizard()).getName());
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Predicate");
            column.getColumn().setWidth(300);
            column.setEditingSupport((EditingSupport)new PredicateEditingSupport(this.tableViewer, dbc, "eval", WizardObserverSwitchImage.this.getBControl().getVisualization(), this.getShell()));
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Image");
            column.getColumn().setWidth(180);
            column.setEditingSupport((EditingSupport)new AttributeExpressionEdittingSupport((ColumnViewer)this.tableViewer, WizardObserverSwitchImage.this.getBControl(), "de.bmotionstudio.gef.editor.attribute.BAttributeImage"){

                @Override
                protected Object getValue(Object element) {
                    ToggleObjectImage evalObject = (ToggleObjectImage)element;
                    return evalObject.getImage();
                }

                @Override
                protected void setValue(Object element, Object value) {
                    if (value == null) {
                        return;
                    }
                    ((ToggleObjectImage)element).setImage(value.toString());
                }
            });
            column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText("Expression?");
            column.getColumn().setWidth(100);
            column.setEditingSupport((EditingSupport)new IsExpressionModeEditingSupport((ColumnViewer)this.tableViewer, WizardObserverSwitchImage.this.getBControl()){

                @Override
                protected void setValue(Object element, Object value) {
                    Boolean bol = Boolean.valueOf(String.valueOf(value));
                    ToggleObjectImage obj = (ToggleObjectImage)element;
                    obj.setIsExpressionMode(bol);
                }
            });
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObserverLabelProvider(new IObservableMap[]{BeanProperties.value(ObserverEvalObject.class, (String)"eval").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(ToggleObjectImage.class, (String)"image").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(ObserverEvalObject.class, (String)"isExpressionMode").observeDetail(contentProvider.getKnownElements())}));
            final WritableList input = new WritableList(((SwitchImage)WizardObserverSwitchImage.this.getObserver()).getToggleObjects(), ToggleObjectImage.class);
            this.tableViewer.setInput((Object)input);
            Composite comp = new Composite(container, 0);
            comp.setLayout((Layout)new RowLayout());
            comp.setLayoutData((Object)new GridData(128));
            Button btRemove = new Button(comp, 8);
            btRemove.setText("Remove");
            btRemove.setImage(BMotionStudioImage.getImage("icon_delete_edit"));
            btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ObserverSwitchImagePage.this.tableViewer.getSelection().isEmpty()) {
                        return;
                    }
                    ToggleObjectImage toggleObj = (ToggleObjectImage)((IStructuredSelection)ObserverSwitchImagePage.this.tableViewer.getSelection()).getFirstElement();
                    input.remove((Object)toggleObj);
                }
            });
            Button btAdd = new Button(comp, 8);
            btAdd.setText("Add");
            btAdd.setImage(BMotionStudioImage.getImage("icon_new_wiz"));
            btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToggleObjectImage toggleObj = new ToggleObjectImage("#PREDICATE", "", "");
                    input.add((Object)toggleObj);
                    ObserverSwitchImagePage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)toggleObj));
                }
            });
            this.setControl((Control)container);
        }
    }
}

