/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.model;

import de.bmotionstudio.gef.editor.model.BMotionGuide;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BMotionRuler
implements Serializable {
    public static final transient String PROPERTY_CHILDREN = "children changed";
    public static final transient String PROPERTY_UNIT = "units changed";
    static final transient long serialVersionUID = 1L;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private int unit;
    private boolean horizontal;
    private List<BMotionGuide> guides = new ArrayList<BMotionGuide>();

    public BMotionRuler(boolean isHorizontal) {
        this(isHorizontal, 2);
    }

    public BMotionRuler(boolean isHorizontal, int unit) {
        this.horizontal = isHorizontal;
        this.setUnit(unit);
    }

    protected Object readResolve() {
        this.listeners = new PropertyChangeSupport(this);
        return this;
    }

    public void addGuide(BMotionGuide guide) {
        if (!this.guides.contains(guide)) {
            guide.setHorizontal(!this.isHorizontal());
            this.guides.add(guide);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public List<BMotionGuide> getGuides() {
        return this.guides;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removeGuide(BMotionGuide guide) {
        if (this.guides.remove(guide)) {
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHidden(boolean isHidden) {
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            int oldUnit = this.unit;
            this.unit = newUnit;
            this.listeners.firePropertyChange(PROPERTY_UNIT, oldUnit, newUnit);
        }
    }
}

