/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TextFigure
extends AbstractBMotionFigure {
    private TextFlow textFlow;
    protected Image layerImage;
    private Color foregroundColor;
    private Font font;

    public TextFigure() {
        this.setBorder((Border)new MarginBorder(1));
        FlowPage flowPage = new FlowPage();
        this.textFlow = new TextFlow();
        this.textFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.textFlow, 1));
        flowPage.add((IFigure)this.textFlow);
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)flowPage);
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setText(String newText) {
        this.textFlow.setText(newText);
    }

    public void setTextColor(RGB rgb) {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        this.foregroundColor = new Color((Device)Display.getDefault(), rgb);
        this.textFlow.setForegroundColor(this.foregroundColor);
    }

    public void setBackgroundVisible(Boolean bol) {
        this.setOpaque(bol);
    }

    public void setFont(String fontData) {
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = new Font((Device)Display.getDefault(), new FontData(fontData));
        this.textFlow.setFont(this.font);
    }

    public Font getFont() {
        return this.textFlow.getFont();
    }

    public void setLayout(Rectangle rect) {
        this.getParent().setConstraint((IFigure)this, (Object)rect);
    }

    @Override
    public void deactivateFigure() {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.layerImage != null) {
            this.layerImage.dispose();
        }
    }
}

