/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractTableFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TableCellFigure
extends AbstractTableFigure {
    private String text;
    private Color backgroundColor;
    private Color textColor;

    public TableCellFigure() {
        this.setOpaque(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle r = this.getClientArea();
        g.setBackgroundColor(this.backgroundColor);
        g.fillRectangle(r.x, r.y, r.x + r.width, r.y + r.height);
        g.setForegroundColor(this.textColor);
        g.drawText(this.text, r.x + 3, r.y + 3);
        Color foregroundColor = this.getForegroundColor();
        if (foregroundColor != null) {
            g.setForegroundColor(foregroundColor);
        }
        g.drawLine(r.x, r.y, r.x + r.width, r.y);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public void setBackgroundColor(RGB rgb) {
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = new Color((Device)Display.getDefault(), rgb);
        this.repaint();
    }

    public void setTextColor(RGB rgb) {
        if (this.textColor != null) {
            this.textColor.dispose();
        }
        this.textColor = new Color((Device)Display.getDefault(), rgb);
        this.repaint();
    }

    @Override
    public void deactivateFigure() {
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        if (this.textColor != null) {
            this.textColor.dispose();
        }
        super.deactivateFigure();
    }

    public void setFont(String string) {
    }
}

