/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.figure;

import de.bmotionstudio.gef.editor.figure.AbstractBMotionFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CompositeFigure
extends AbstractBMotionFigure {
    protected Image layerImage;
    private ImageData imageData;
    private Dimension size = new Dimension();
    private boolean hasImage;

    public CompositeFigure() {
        XYLayout layout = new XYLayout();
        this.setLayoutManager((LayoutManager)layout);
        PaletteData palette = new PaletteData(new RGB[]{ColorConstants.white.getRGB()});
        this.imageData = new ImageData(1, 1, 8, palette);
        this.imageData.alpha = 255;
        this.imageData.setPixel(0, 0, 0);
        this.layerImage = new Image((Device)Display.getDefault(), this.imageData);
        this.hasImage = false;
        this.setOpaque(true);
    }

    public void setBackgroundColor(RGB rgb) {
        this.imageData.palette.colors[0] = rgb;
        if (!this.hasImage) {
            if (this.layerImage != null && !this.layerImage.isDisposed()) {
                this.layerImage.dispose();
            }
            this.layerImage = new Image((Device)Display.getDefault(), this.imageData);
            this.repaint();
        }
    }

    public void paintFigure(Graphics g) {
        if (this.getImage() == null) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        if (this.hasImage) {
            int aWidth = rectangle.width;
            int aHeight = rectangle.height;
            int countX = aWidth / this.getImage().getBounds().width;
            int countY = aHeight / this.getImage().getBounds().height;
            int i = 0;
            while (i <= countX) {
                int z = 0;
                while (z <= countY) {
                    g.drawImage(this.getImage(), this.getBounds().x + i * this.getImage().getBounds().width, this.getBounds().y + z * this.getImage().getBounds().height);
                    ++z;
                }
                ++i;
            }
        } else {
            g.drawImage(this.getImage(), 0, 0, 1, 1, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setImage(Image image) {
        if (this.layerImage != null) {
            this.layerImage.dispose();
        }
        this.layerImage = image;
        if (this.layerImage != null) {
            this.size = new Rectangle(image.getBounds()).getSize();
            this.hasImage = true;
        } else {
            this.layerImage = new Image(null, this.imageData);
            this.size = new Dimension();
            this.hasImage = false;
        }
        this.revalidate();
        this.repaint();
    }

    public Image getImage() {
        return this.layerImage;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.getInsets() == NO_INSETS) {
            return this.size;
        }
        Insets i = this.getInsets();
        return this.size.getExpanded(i.getWidth(), i.getHeight());
    }

    public void setLayout(Rectangle rect) {
        this.getParent().setConstraint((IFigure)this, (Object)rect);
    }

    @Override
    public void deactivateFigure() {
        if (this.layerImage != null) {
            this.layerImage.dispose();
        }
    }
}

