/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.edit;

import de.bmotionstudio.gef.editor.edit.IPopupListener;
import de.bmotionstudio.gef.editor.edit.PopupResult;
import de.bmotionstudio.gef.editor.edit.TextEditorWindow;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PopupCellEditor
extends TextCellEditor {
    private Shell parentShell;
    private TextEditorWindow dialog;
    private boolean isOpen = false;
    private int counter = 0;

    public PopupCellEditor(Composite parent, Shell parentShell) {
        super(parent);
        this.parentShell = parentShell;
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evt) {
            }

            public void focusGained(FocusEvent evt) {
                if (!PopupCellEditor.this.isOpen && PopupCellEditor.this.counter == 0) {
                    ++PopupCellEditor.this.counter;
                    PopupCellEditor.this.openDialogBox();
                } else if (PopupCellEditor.this.counter == 1) {
                    PopupCellEditor.this.counter = 0;
                }
            }
        });
    }

    protected void openDialogBox() {
        this.dialog = new TextEditorWindow(this.parentShell, this.text);
        this.dialog.addPopupListener(new IPopupListener(){

            @Override
            public void popupOpened() {
                PopupCellEditor.this.isOpen = true;
            }

            @Override
            public void popupClosed() {
                PopupCellEditor.this.isOpen = false;
            }
        });
        PopupResult result = this.dialog.openPopup();
        if (result.getReturncode() == 0) {
            this.setValue(result.getValue());
        } else {
            result.getReturncode();
        }
    }

    protected void focusLost() {
        if (!this.isOpen) {
            super.focusLost();
        }
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }
}

