/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor.action;

import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionStudioImage;
import de.bmotionstudio.gef.editor.action.BMotionObserverWizardDialog;
import de.bmotionstudio.gef.editor.command.RemoveObserverCommand;
import de.bmotionstudio.gef.editor.command.SetObserverCommand;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.observer.Observer;
import de.bmotionstudio.gef.editor.observer.ObserverWizard;
import de.prob.logging.Logger;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkbenchPart;

public class OpenObserverAction
extends SelectionAction {
    private String className;

    public OpenObserverAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        BControl actionControl = this.getControl();
        if (actionControl != null) {
            Observer oldObserver = null;
            Observer observer = this.getControl().getObserver(this.getClassName());
            if (observer == null) {
                try {
                    observer = (Observer)BMotionEditorPlugin.getObserverExtension(this.getClassName()).createExecutableExtension("class");
                }
                catch (CoreException coreException) {}
            } else {
                try {
                    oldObserver = observer.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
            ObserverWizard wizard = observer.getWizard(actionControl);
            if (wizard != null) {
                BMotionObserverWizardDialog dialog = new BMotionObserverWizardDialog(this.getWorkbenchPart(), (IWizard)wizard);
                dialog.create();
                dialog.getShell().setSize(wizard.getSize());
                String title = "Observer: " + observer.getName() + " Control: " + this.getControl().getID();
                wizard.setWindowTitle("BMotion Studio Observer Wizard");
                dialog.setTitle(title);
                dialog.setMessage(observer.getDescription());
                dialog.setTitleImage(BMotionStudioImage.getImage("logo_bmotion64"));
                int status = dialog.open();
                if (status == 0) {
                    if (wizard.isObserverDelete().booleanValue()) {
                        RemoveObserverCommand cmd = this.createRemoveObserverCommand(observer, actionControl);
                        this.execute(cmd);
                    } else {
                        SetObserverCommand cmd = this.createObserverSetCommand(actionControl, observer, oldObserver);
                        this.execute(cmd);
                    }
                } else if (status == 1) {
                    if (oldObserver != null) {
                        actionControl.getObservers().put(oldObserver.getID(), oldObserver);
                    }
                } else if (status == 3) {
                    RemoveObserverCommand cmd = this.createRemoveObserverCommand(observer, actionControl);
                    this.execute(cmd);
                }
            } else {
                Logger.notifyUser((String)("The Observer \"" + observer.getName() + "\" does not support a wizard."));
            }
        }
    }

    private RemoveObserverCommand createRemoveObserverCommand(Observer observer, BControl control) {
        RemoveObserverCommand cmd = new RemoveObserverCommand();
        cmd.setControl(control);
        cmd.setObserver(observer);
        return cmd;
    }

    public SetObserverCommand createObserverSetCommand(BControl control, Observer newObserver, Observer oldObserver) {
        SetObserverCommand cmd = new SetObserverCommand();
        cmd.setNewObserver(newObserver);
        cmd.setOldObserver(oldObserver);
        cmd.setControl(control);
        return cmd;
    }

    public SetObserverCommand createObserverSetCommand(BControl control, Observer newObserver) {
        return this.createObserverSetCommand(control, newObserver, null);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    protected BControl getControl() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.get(0) instanceof EditPart) {
            EditPart part = (EditPart)objects.get(0);
            BControl control = null;
            if (part.getModel() instanceof BControl) {
                control = (BControl)part.getModel();
            }
            return control;
        }
        return null;
    }
}

