/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import com.thoughtworks.xstream.XStream;
import de.bmotionstudio.gef.editor.BMSContextMenuProvider;
import de.bmotionstudio.gef.editor.BMotionEditorPlugin;
import de.bmotionstudio.gef.editor.BMotionSelectionSynchronizer;
import de.bmotionstudio.gef.editor.BMotionStudioEditor;
import de.bmotionstudio.gef.editor.BMotionStudioPropertySheet;
import de.bmotionstudio.gef.editor.CustomSortPropertySheetEntry;
import de.bmotionstudio.gef.editor.EditorPaletteFactory;
import de.bmotionstudio.gef.editor.IInstallActions;
import de.bmotionstudio.gef.editor.IInstallMenu;
import de.bmotionstudio.gef.editor.action.CopyAction;
import de.bmotionstudio.gef.editor.action.OpenObserverAction;
import de.bmotionstudio.gef.editor.action.OpenSchedulerEventAction;
import de.bmotionstudio.gef.editor.action.PasteAction;
import de.bmotionstudio.gef.editor.internal.BControlTransferDropTargetListener;
import de.bmotionstudio.gef.editor.library.AttributeTransferDropTargetListener;
import de.bmotionstudio.gef.editor.model.BMotionRuler;
import de.bmotionstudio.gef.editor.model.BMotionRulerProvider;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.bmotionstudio.gef.editor.part.BMSAbstractEditPart;
import de.bmotionstudio.gef.editor.part.BMSAbstractTreeEditPart;
import de.bmotionstudio.gef.editor.part.BMSEditPartFactory;
import de.bmotionstudio.gef.editor.part.BMSTreeEditPartFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleRulerVisibilityAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class BMotionStudioEditorPage
extends GraphicalEditorWithFlyoutPalette {
    public static final String ID = "de.bmotionstudio.gef.editor";
    private boolean isDirty;
    private KeyHandler sharedKeyHandler;
    private Visualization visualization;
    private RulerComposite rulerComp;
    private BMotionStudioEditor bmotionStudioEditor;
    private BMotionSelectionSynchronizer bmotionSelectionSynchronizer;
    private Color gridColor = new Color(null, 240, 240, 240);
    private PaletteRoot palette;
    private PropertyChangeListener viewerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("SnapToGrid.isVisible") || propertyName.equals("SnapToGrid.isEnabled")) {
                BMotionStudioEditorPage.this.setDirty(true);
            }
        }
    };
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            BMotionStudioEditorPage.this.setDirty(BMotionStudioEditorPage.this.getCommandStack().isDirty());
        }
    };

    public BMotionStudioEditorPage(Visualization visualization, BMotionStudioEditor bmotionStudioEditor) {
        this.visualization = visualization;
        this.bmotionStudioEditor = bmotionStudioEditor;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!((Object)((Object)this.getBMotionStudioEditor())).equals(this.getSite().getPage().getActiveEditor())) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement instanceof BMSAbstractEditPart || selectedElement instanceof BMSAbstractTreeEditPart) {
            this.updateActions(this.getSelectionActions());
        }
    }

    public void init(IEditorSite iSite, IEditorInput iInput) throws PartInitException {
        super.init(iSite, iInput);
        this.setSite((IWorkbenchPartSite)iSite);
        this.getCommandStack().addCommandStackListener(this.getCommandStackListener());
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getGraphicalViewer().setContents((Object)this.getVisualization());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new BControlTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.visualization));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new AttributeTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.getSite().getPart()));
        this.getPalettePreferences().setPaletteState(4);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }

            protected void hookPaletteViewer(PaletteViewer viewer) {
                super.hookPaletteViewer(viewer);
            }
        };
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createOutputStream(OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, "UTF8");
        XStream xstream = new XStream();
        BMotionEditorPlugin.setAliases(xstream);
        xstream.toXML((Object)this.visualization, (Writer)writer);
    }

    public void doSave(IProgressMonitor iMonitor) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.saveProperties();
            this.createOutputStream(out);
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, iMonitor);
            this.getCommandStack().markSaveLocation();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener(this.getCommandStackListener());
        this.getGraphicalViewer().removePropertyChangeListener(this.viewerListener);
        super.dispose();
    }

    public void doSaveAs() {
        throw new IllegalAccessError("No way to enter this method.");
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == IContentOutlinePage.class) {
            return new BMotionOutlinePage();
        }
        if (type == IPropertySheetPage.class) {
            BMotionStudioPropertySheet page = new BMotionStudioPropertySheet();
            page.setRootEntry((IPropertySheetEntry)new CustomSortPropertySheetEntry(this.getCommandStack()));
            return page;
        }
        return super.getAdapter(type);
    }

    public void gotoMarker(IMarker iMarker) {
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'+', (int)16777259, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'-', (int)16777261, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public void setDirty(boolean dirty) {
        if (this.isDirty() != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        this.installCustomActions();
        SelectionAction action = new CopyAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.installObserverActions();
        this.installSchedulerActions();
    }

    private void installObserverActions() {
        ActionRegistry registry = this.getActionRegistry();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint("de.bmotionstudio.gef.editor.observer");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("observer".equals(configurationElement.getName())) {
                    String observerClassName = configurationElement.getAttribute("class");
                    OpenObserverAction action = new OpenObserverAction((IWorkbenchPart)this);
                    action.setId("de.bmotionstudio.gef.editor.observerAction." + observerClassName);
                    action.setClassName(observerClassName);
                    registry.registerAction((IAction)action);
                    this.getSelectionActions().add("de.bmotionstudio.gef.editor.observerAction." + observerClassName);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void installSchedulerActions() {
        ActionRegistry registry = this.getActionRegistry();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint("de.bmotionstudio.gef.editor.schedulerEvent");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("schedulerEvent".equals(configurationElement.getName())) {
                    String sClassName = configurationElement.getAttribute("class");
                    OpenSchedulerEventAction action = new OpenSchedulerEventAction((IWorkbenchPart)this);
                    action.setId("de.bmotionstudio.gef.editor.SchedulerEventAction." + sClassName);
                    action.setClassName(sClassName);
                    registry.registerAction((IAction)action);
                    this.getSelectionActions().add("de.bmotionstudio.gef.editor.SchedulerEventAction." + sClassName);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void installCustomActions() {
        ActionRegistry registry = this.getActionRegistry();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint("de.bmotionstudio.gef.editor.installActions");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("action".equals(configurationElement.getName())) {
                    try {
                        IInstallActions installActionsClass = (IInstallActions)configurationElement.createExecutableExtension("class");
                        installActionsClass.installActions((WorkbenchPart)this);
                        HashMap<String, Action> actionMap = installActionsClass.getActionMap();
                        for (Map.Entry<String, Action> entry : actionMap.entrySet()) {
                            registry.registerAction((IAction)entry.getValue());
                            if (!(entry.getValue() instanceof SelectionAction)) continue;
                            this.getSelectionActions().add(entry.getKey());
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected Control getGraphicalControl() {
        return this.rulerComp;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new RulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new BMSEditPartFactory());
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        GridLayer gridLayer = (GridLayer)rootEditPart.getLayer((Object)"Grid Layer");
        gridLayer.setForegroundColor(this.gridColor);
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0, 20.0};
        manager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        manager.setZoomLevelContributions(zoomContributions);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)0), (Object)MouseWheelZoomHandler.SINGLETON);
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        this.loadProperties();
        this.getActionRegistry().registerAction((IAction)new ToggleRulerVisibilityAction(this.getGraphicalViewer()));
        this.getActionRegistry().registerAction((IAction)new ToggleSnapToGeometryAction(this.getGraphicalViewer()));
        this.getActionRegistry().registerAction((IAction)new ToggleGridAction(this.getGraphicalViewer()));
        BMSContextMenuProvider provider = new BMSContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        viewer.addPropertyChangeListener(this.viewerListener);
    }

    protected void loadProperties() {
        BMotionRuler ruler = this.getVisualization().getRuler(8);
        BMotionRulerProvider provider = null;
        if (ruler != null) {
            provider = new BMotionRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("vertical ruler", (Object)provider);
        ruler = this.getVisualization().getRuler(1);
        provider = null;
        if (ruler != null) {
            provider = new BMotionRulerProvider(ruler);
        }
        this.getGraphicalViewer().setProperty("horizontal ruler", (Object)provider);
        this.getGraphicalViewer().setProperty("ruler$visibility", (Object)this.getVisualization().getRulerVisibility());
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)this.getVisualization().isSnapToGeometryEnabled());
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)this.getVisualization().isGridEnabled());
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)this.getVisualization().isGridEnabled());
        this.getPalettePreferences().setPaletteState(4);
    }

    protected void saveProperties() {
        this.getVisualization().setRulerVisibility((Boolean)this.getGraphicalViewer().getProperty("ruler$visibility"));
        this.getVisualization().setGridEnabled((Boolean)this.getGraphicalViewer().getProperty("SnapToGrid.isEnabled"));
        this.getVisualization().setSnapToGeometry((Boolean)this.getGraphicalViewer().getProperty("SnapToGeometry.isEnabled"));
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected CommandStackListener getCommandStackListener() {
        return this.commandStackListener;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.palette == null) {
            this.palette = new EditorPaletteFactory().createPalette(this.visualization);
        }
        return this.palette;
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        if (this.bmotionSelectionSynchronizer == null) {
            this.bmotionSelectionSynchronizer = new BMotionSelectionSynchronizer();
        }
        return this.bmotionSelectionSynchronizer;
    }

    private void buildCustomActions(IActionBars bars, ActionRegistry ar) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint("de.bmotionstudio.gef.editor.installMenu");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("menu".equals(configurationElement.getName())) {
                    try {
                        IInstallMenu installMenuClass = (IInstallMenu)configurationElement.createExecutableExtension("class");
                        installMenuClass.installBar(bars, this.getActionRegistry());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    public void setBMotionStudioEditor(BMotionStudioEditor bmotionStudioEditor) {
        this.bmotionStudioEditor = bmotionStudioEditor;
    }

    public BMotionStudioEditor getBMotionStudioEditor() {
        return this.bmotionStudioEditor;
    }

    public ScalableRootEditPart getRootEditPart() {
        return (ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart();
    }

    protected class BMotionOutlinePage
    extends ContentOutlinePage {
        private SashForm sash;
        private ScrollableThumbnail thumbnail;
        private DisposeListener disposeListener;

        public BMotionOutlinePage() {
            super((EditPartViewer)new TreeViewer());
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            IActionBars bars = pageSite.getActionBars();
            ActionRegistry ar = BMotionStudioEditorPage.this.getActionRegistry();
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), ar.getAction((Object)ActionFactory.UNDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), ar.getAction((Object)ActionFactory.REDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), ar.getAction((Object)ActionFactory.DELETE.getId()));
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), ar.getAction((Object)ActionFactory.COPY.getId()));
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), ar.getAction((Object)ActionFactory.PASTE.getId()));
            BMotionStudioEditorPage.this.buildCustomActions(bars, ar);
            bars.updateActionBars();
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)BMotionStudioEditorPage.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new BMSTreeEditPartFactory());
            BMSContextMenuProvider provider = new BMSContextMenuProvider(this.getViewer(), BMotionStudioEditorPage.this.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)provider);
            this.getViewer().setKeyHandler(BMotionStudioEditorPage.this.getCommonKeyHandler());
        }

        protected void initializeOutlineViewer() {
            this.setContents(BMotionStudioEditorPage.this.getVisualization());
        }

        public void setContents(Object contents) {
            this.getViewer().setContents(contents);
        }

        protected void hookOutlineViewer() {
            BMotionStudioEditorPage.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void unhookOutlineViewer() {
            BMotionStudioEditorPage.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (BMotionStudioEditorPage.this.getGraphicalViewer().getControl() != null && !BMotionStudioEditorPage.this.getGraphicalViewer().getControl().isDisposed()) {
                BMotionStudioEditorPage.this.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
            }
        }

        public void createControl(Composite parent) {
            this.initializeOverview(parent);
            BMotionStudioEditorPage.this.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
            this.createMenu();
        }

        private void createMenu() {
            Action expandAllAction = new Action("Expand All"){

                public void run() {
                    TreeItem[] treeItemArray = ((Tree)BMotionOutlinePage.this.getViewer().getControl()).getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        item.setExpanded(true);
                        ++n2;
                    }
                }
            };
            Action collapseAllAction = new Action("Collapse All"){

                public void run() {
                    TreeItem[] treeItemArray = ((Tree)BMotionOutlinePage.this.getViewer().getControl()).getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        item.setExpanded(false);
                        ++n2;
                    }
                }
            };
            this.getSite().getActionBars().getMenuManager().add((IAction)expandAllAction);
            this.getSite().getActionBars().getMenuManager().add((IAction)collapseAllAction);
        }

        protected void initializeOverview(Composite parent) {
            this.sash = new SashForm(parent, 512);
            this.getViewer().createControl((Composite)this.sash);
            Canvas canvas = new Canvas((Composite)this.sash, 2048);
            canvas.setBackground(Display.getDefault().getSystemColor(1));
            LightweightSystem lws = new LightweightSystem(canvas);
            this.thumbnail = new ScrollableThumbnail((Viewport)((ScalableRootEditPart)BMotionStudioEditorPage.this.getGraphicalViewer().getRootEditPart()).getFigure());
            this.thumbnail.setSource(((ScalableRootEditPart)BMotionStudioEditorPage.this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (BMotionOutlinePage.this.thumbnail != null) {
                        BMotionOutlinePage.this.thumbnail.deactivate();
                        BMotionOutlinePage.this.thumbnail = null;
                    }
                }
            };
        }

        public Control getControl() {
            return this.sash;
        }

        public void dispose() {
            this.unhookOutlineViewer();
            BMotionStudioEditorPage.this.gridColor.dispose();
            super.dispose();
        }
    }
}

