/*
 * Decompiled with CFR 0.152.
 */
package de.bmotionstudio.gef.editor;

import de.bmotionstudio.gef.editor.StaticListenerRegistry;
import de.bmotionstudio.gef.editor.model.BControl;
import de.bmotionstudio.gef.editor.model.Visualization;
import de.prob.core.Animator;
import de.prob.core.IAnimationListener;
import de.prob.core.command.EvaluationGetValuesCommand;
import de.prob.core.command.EvaluationInsertFormulaCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.parserbase.ProBParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;

public class Animation
implements IAnimationListener {
    private Animator animator;
    private final Map<String, Operation> currentStateOperations;
    private final Map<String, EvaluationElement> cachedEvalElements = new HashMap<String, EvaluationElement>();
    private State currentState;
    private Visualization visualization;
    private Boolean observerCallBack = true;

    public Animation(Animator anim, Visualization visualization) {
        StaticListenerRegistry.registerListener(this);
        this.currentStateOperations = new HashMap<String, Operation>();
        this.animator = anim;
        this.visualization = visualization;
        this.visualization.setAnimation(this);
    }

    private void setNewState(State state) {
        this.currentState = state;
        this.currentStateOperations.clear();
        for (Operation op : state.getEnabledOperations()) {
            this.currentStateOperations.put(op.getName(), op);
        }
    }

    public void currentStateChanged(State currentState, Operation operation) {
        this.setNewState(currentState);
        this.updateCachedExpressions(currentState);
        if (currentState.isInitialized()) {
            if (this.animator == null) {
                this.animator = Animator.getAnimator();
            }
            this.checkObserver();
        }
    }

    private void updateCachedExpressions(State currentState) {
        try {
            EvaluationGetValuesCommand.getValuesForExpressionsCached((State)currentState, this.cachedEvalElements.values());
        }
        catch (ProBException proBException) {}
    }

    private void collectAllBControls(List<BControl> allBControls, BControl control) {
        if (control.getChildrenArray().isEmpty()) {
            return;
        }
        for (BControl bcontrol : control.getChildrenArray()) {
            allBControls.add(bcontrol);
            this.collectAllBControls(allBControls, bcontrol);
        }
    }

    public void checkObserver() {
        if (this.visualization.isRunning().booleanValue()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<BControl> allBControls = new ArrayList<BControl>();
                    allBControls.add(Animation.this.visualization);
                    Animation.this.collectAllBControls(allBControls, Animation.this.visualization);
                    for (BControl c : allBControls) {
                        c.checkObserver(Animation.this);
                    }
                }
            });
        }
    }

    public State getState() {
        return this.currentState;
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public Operation getCurrentStateOperation(String operation) {
        return this.currentStateOperations.get(operation);
    }

    public Visualization getVisualization() {
        return this.visualization;
    }

    public void unregister() {
        StaticListenerRegistry.unregisterListener(this);
    }

    public void setObserverCallBack(Boolean observerCallBack) {
        this.observerCallBack = observerCallBack;
    }

    public boolean isObserverCallBack() {
        return this.observerCallBack;
    }

    public EvaluationElement getCachedEvalElement(String expressionStr, boolean isPredicate) throws UnsupportedOperationException, ProBException, ProBParseException {
        EvaluationElement evalElement;
        if (this.cachedEvalElements.containsKey(expressionStr)) {
            evalElement = this.cachedEvalElements.get(expressionStr);
        } else {
            evalElement = this.createPredicateExpressionElement(expressionStr, isPredicate);
            this.cachedEvalElements.put(expressionStr, evalElement);
        }
        return evalElement;
    }

    private EvaluationElement createPredicateExpressionElement(String expressionStr, boolean isPredicate) throws UnsupportedOperationException, ProBException, ProBParseException {
        EvaluationInsertFormulaCommand.FormulaType type = isPredicate ? EvaluationInsertFormulaCommand.FormulaType.PREDICATE : EvaluationInsertFormulaCommand.FormulaType.EXPRESSION;
        EvaluationElement evaluationElement = EvaluationInsertFormulaCommand.insertFormula((Animator)this.animator, (EvaluationInsertFormulaCommand.FormulaType)type, (String)expressionStr);
        return evaluationElement;
    }

    public Map<String, Operation> getCurrentStateOperations() {
        return this.currentStateOperations;
    }
}

