/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.prettyprint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eventb.emf.core.EventBCommented;
import org.eventb.emf.core.EventBDerived;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.EventBNamedCommentedPredicateElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.texttools.prettyprint.ContextPrintSwitch;
import org.eventb.texttools.prettyprint.MachinePrintSwitch;
import org.eventb.texttools.prettyprint.PrettyPrintConstants;

public class PrettyPrinter
implements PrettyPrintConstants {
    protected final String linebreak;
    private final Map<String, Object> preferences;
    private final MachinePrintSwitch machineSwitch;
    private final ContextPrintSwitch contextSwitch;
    private final StringBuilder buffer;
    private int indentationLevel = 0;
    private int indentWidth;
    private int tabWidth;
    private Boolean useTabsForIndentation;

    public PrettyPrinter(StringBuilder buffer, String linebreak, Map<String, Object> preferences) {
        this.buffer = buffer;
        this.linebreak = linebreak;
        this.preferences = preferences != null ? preferences : new HashMap<String, Object>();
        this.machineSwitch = new MachinePrintSwitch(this);
        this.contextSwitch = new ContextPrintSwitch(this);
        this.initPreferences();
    }

    private void initPreferences() {
        this.indentWidth = (Integer)this.getPreference("indentation.depth", 2);
        this.useTabsForIndentation = (Boolean)this.getPreference("use.tabs.for.indentation", false);
        this.tabWidth = (Integer)this.getPreference("tab.width", 4);
    }

    public void prettyPrint(EventBObject emfObject) {
        String packageNsURI = emfObject.eClass().getEPackage().getNsURI();
        if (packageNsURI.equals("http://emf.eventb.org/models/core/machine/2022")) {
            this.machineSwitch.doSwitch((EObject)emfObject);
        } else if (packageNsURI.equals("http://emf.eventb.org/models/core/context/2022")) {
            this.contextSwitch.doSwitch((EObject)emfObject);
        }
    }

    protected Object getPreference(String key, Object defaultValue) {
        if (this.preferences.containsKey(key)) {
            return this.preferences.get(key);
        }
        return defaultValue;
    }

    protected void changeIndent(int byValue) {
        Assert.isTrue((this.indentationLevel + byValue >= 0 ? 1 : 0) != 0);
        this.indentationLevel += byValue;
    }

    protected void increaseIndentLevel() {
        this.changeIndent(this.indentWidth);
    }

    protected void decreaseIndentLevel() {
        this.changeIndent(-this.indentWidth);
    }

    protected void append(char c) {
        this.buffer.append(c);
    }

    protected void append(String string) {
        this.buffer.append(string);
    }

    protected void appendWithSpace(String string) {
        this.buffer.append(string);
        this.buffer.append(' ');
    }

    protected void appendWithSpace(char c) {
        this.buffer.append(c);
        this.buffer.append(' ');
    }

    protected void appendWithLineBreak(String string) {
        this.buffer.append(string);
        this.appendLineBreak();
    }

    protected void appendLineBreak() {
        this.buffer.append(this.linebreak);
    }

    protected void appendComment(EventBCommented commentedElement) {
        StringTokenizer tokenizer;
        String comment = commentedElement.getComment();
        if (!this.hasComment(commentedElement)) {
            return;
        }
        if (this.buffer.length() > 0 && !Character.isWhitespace(this.buffer.charAt(this.buffer.length() - 1))) {
            this.append(' ');
        }
        if ((tokenizer = new StringTokenizer(comment, "\n\r")).countTokens() <= 1) {
            this.append("// ");
            this.append(comment.trim());
            this.appendLineBreak();
        } else {
            this.appendLineBreak();
            this.adjustIndent();
            this.append("/* ");
            int subIdentation = this.getCurrentIndentation() - this.indentationLevel - 1;
            this.append(tokenizer.nextToken().trim());
            this.appendLineBreak();
            this.changeIndent(subIdentation);
            while (tokenizer.hasMoreTokens()) {
                this.adjustIndent();
                this.append(tokenizer.nextToken().trim());
                if (!tokenizer.hasMoreTokens()) continue;
                this.appendLineBreak();
            }
            this.append(" */");
            this.appendLineBreak();
            this.changeIndent(-subIdentation);
        }
    }

    protected boolean hasComment(EventBCommented commentedElement) {
        String comment = commentedElement.getComment();
        return comment != null && comment.length() > 0;
    }

    protected void ensureNewLine() {
        int lastLinebreak = this.buffer.lastIndexOf(this.linebreak);
        if (lastLinebreak < this.buffer.length() - 1 && this.buffer.substring(lastLinebreak, this.buffer.length() - 1).trim().length() > 0) {
            this.appendLineBreak();
        }
    }

    protected void adjustIndent() {
        int indentRemaining = this.indentationLevel - this.getCurrentIndentation() + 1;
        if (this.useTabsForIndentation.booleanValue()) {
            while (indentRemaining >= this.tabWidth) {
                this.append('\t');
                indentRemaining -= this.tabWidth;
            }
        }
        while (indentRemaining > 0) {
            this.append(' ');
            --indentRemaining;
        }
    }

    protected void appendLabeledPredicate(EventBNamedCommentedPredicateElement object, boolean derivedPossible) {
        this.adjustIndent();
        if (object instanceof EventBDerived && ((EventBDerived)object).isTheorem()) {
            this.appendWithSpace("theorem");
        }
        this.appendLabel((EventBNamed)object);
        this.appendFormula(object.getPredicate(), this.hasComment((EventBCommented)object));
        this.appendComment((EventBCommented)object);
    }

    private int getCurrentIndentation() {
        int lastLinebreak = this.buffer.lastIndexOf(this.linebreak);
        return this.buffer.length() - lastLinebreak;
    }

    protected void appendFormula(String formula, boolean followedByComment) {
        StringTokenizer tokenizer = new StringTokenizer(formula, "\n\r");
        if (tokenizer.countTokens() <= 1) {
            if (!followedByComment) {
                this.appendWithLineBreak(formula.trim());
            } else {
                this.append(formula.trim());
            }
        } else {
            int subIndent = this.getCurrentIndentation() - this.indentationLevel - 1;
            this.appendWithLineBreak(tokenizer.nextToken().trim());
            this.changeIndent(subIndent);
            while (tokenizer.hasMoreTokens()) {
                this.adjustIndent();
                String line = tokenizer.nextToken().trim();
                if (tokenizer.hasMoreTokens() || !followedByComment) {
                    this.appendWithLineBreak(line);
                    continue;
                }
                this.append(line);
            }
            this.changeIndent(-subIndent);
        }
    }

    protected void appendLabel(EventBNamed namedElement) {
        String name = namedElement.getName();
        this.append('@');
        this.appendWithSpace(name);
    }

    protected void appendStringList(List<String> strings) {
        int i = 0;
        while (i < strings.size()) {
            this.appendWithSpace(strings.get(i));
            ++i;
        }
    }

    protected void appendNameList(EList<? extends EventBNamed> list, String label, boolean newLineBefore) {
        if (list.size() > 0) {
            if (newLineBefore) {
                this.appendLineBreak();
            }
            this.adjustIndent();
            this.appendWithSpace(label);
            this.appendNamedElementList(list);
        }
    }

    protected void appendNamedElementList(EList<? extends EventBNamed> elements) {
        int subIndent = this.getCurrentIndentation() - this.indentationLevel - 1;
        this.changeIndent(subIndent);
        boolean lastBeganNewLine = true;
        int i = 0;
        while (i < elements.size()) {
            EventBNamed element = (EventBNamed)elements.get(i);
            EventBCommented commented = null;
            if (element instanceof EventBCommented) {
                commented = (EventBCommented)element;
                Object object = commented = this.hasComment(commented) ? commented : null;
                if (commented != null && !lastBeganNewLine) {
                    this.appendLineBreak();
                }
            }
            this.adjustIndent();
            this.append(element.getName());
            if (commented != null) {
                this.appendComment(commented);
                lastBeganNewLine = true;
                if (i < elements.size() - 1) {
                    this.adjustIndent();
                }
            } else {
                this.append(' ');
                lastBeganNewLine = false;
            }
            ++i;
        }
        this.appendLineBreak();
        this.changeIndent(-subIndent);
    }
}

