/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.prettyprint;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eventb.emf.core.EventBCommented;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.EventBNamedCommentedPredicateElement;
import org.eventb.emf.core.machine.Action;
import org.eventb.emf.core.machine.Convergence;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Guard;
import org.eventb.emf.core.machine.Invariant;
import org.eventb.emf.core.machine.Machine;
import org.eventb.emf.core.machine.Variant;
import org.eventb.emf.core.machine.Witness;
import org.eventb.emf.core.machine.util.MachineSwitch;
import org.eventb.texttools.Constants;
import org.eventb.texttools.prettyprint.PrettyPrintConstants;
import org.eventb.texttools.prettyprint.PrettyPrinter;

public class MachinePrintSwitch
extends MachineSwitch<Boolean>
implements PrettyPrintConstants,
Constants {
    private final PrettyPrinter printer;

    protected MachinePrintSwitch(PrettyPrinter prettyPrinter) {
        this.printer = prettyPrinter;
    }

    public Boolean caseMachine(Machine object) {
        EList seesNames;
        this.printer.appendWithSpace("machine");
        this.printer.append(object.getName());
        this.printer.appendComment((EventBCommented)object);
        EList refinesNames = object.getRefinesNames();
        if (refinesNames.size() > 0) {
            this.printer.append(' ');
            this.printer.appendWithSpace("refines");
            this.printer.appendStringList((List<String>)refinesNames);
        }
        if ((seesNames = object.getSeesNames()).size() > 0) {
            this.printer.append(' ');
            this.printer.appendWithSpace("sees");
            this.printer.appendStringList((List<String>)seesNames);
        }
        this.printer.appendLineBreak();
        boolean newLine = (Boolean)this.printer.getPreference("newline.between.clauses", true);
        this.printer.appendNameList((EList<? extends EventBNamed>)object.getVariables(), "variables", newLine);
        this.printInvariants((EList<Invariant>)object.getInvariants(), newLine);
        this.printVariants((EList<Variant>)object.getVariants(), newLine);
        this.printEvents((EList<Event>)object.getEvents(), newLine);
        this.printer.adjustIndent();
        this.printer.appendWithLineBreak("end");
        return true;
    }

    public Boolean caseInvariant(Invariant object) {
        this.printer.appendLabeledPredicate((EventBNamedCommentedPredicateElement)object, true);
        return true;
    }

    public Boolean caseGuard(Guard object) {
        this.printer.appendLabeledPredicate((EventBNamedCommentedPredicateElement)object, false);
        return true;
    }

    public Boolean caseWitness(Witness object) {
        this.printer.appendLabeledPredicate((EventBNamedCommentedPredicateElement)object, false);
        return true;
    }

    public Boolean caseAction(Action object) {
        this.printer.adjustIndent();
        this.printer.appendLabel((EventBNamed)object);
        this.printer.appendFormula(object.getAction(), this.printer.hasComment((EventBCommented)object));
        this.printer.appendComment((EventBCommented)object);
        return true;
    }

    public Boolean caseVariant(Variant object) {
        this.printer.appendFormula(object.getExpression(), this.printer.hasComment((EventBCommented)object));
        this.printer.appendComment((EventBCommented)object);
        return true;
    }

    public Boolean caseEvent(Event object) {
        EList actions;
        EList witnesses;
        this.printer.adjustIndent();
        Convergence convergence = object.getConvergence();
        if (Convergence.CONVERGENT.equals((Object)convergence) && ((Boolean)this.printer.getPreference("print.ordinary.keyword", false)).booleanValue()) {
            this.printer.appendWithSpace("ordinary");
        } else if (Convergence.ANTICIPATED.equals((Object)convergence)) {
            this.printer.appendWithSpace("anticipated");
        } else if (Convergence.CONVERGENT.equals((Object)convergence)) {
            this.printer.appendWithSpace("convergent");
        }
        this.printer.appendWithSpace("event");
        this.printer.append(object.getName());
        this.printer.appendComment((EventBCommented)object);
        EList refinesNames = object.getRefinesNames();
        if (refinesNames.size() > 0) {
            if (this.printer.hasComment((EventBCommented)object)) {
                this.printer.adjustIndent();
            } else {
                this.printer.append(' ');
            }
            if (object.isExtended()) {
                this.printer.appendWithSpace("extends");
            } else {
                this.printer.appendWithSpace("refines");
            }
            this.printer.appendStringList((List<String>)refinesNames);
            this.printer.appendLineBreak();
        }
        if (!this.printer.hasComment((EventBCommented)object) && refinesNames.size() == 0) {
            this.printer.appendLineBreak();
        }
        this.printer.increaseIndentLevel();
        this.printer.appendNameList((EList<? extends EventBNamed>)object.getParameters(), "any", false);
        EList guards = object.getGuards();
        if (guards.size() > 0) {
            this.printer.adjustIndent();
            this.printer.appendWithLineBreak("where");
            this.printer.increaseIndentLevel();
            for (Guard guard : guards) {
                this.doSwitch((EObject)guard);
            }
            this.printer.decreaseIndentLevel();
        }
        if ((witnesses = object.getWitnesses()).size() > 0) {
            this.printer.adjustIndent();
            this.printer.appendWithLineBreak("with");
            this.printer.increaseIndentLevel();
            for (Witness witness : witnesses) {
                this.doSwitch((EObject)witness);
            }
            this.printer.decreaseIndentLevel();
        }
        if ((actions = object.getActions()).size() > 0) {
            this.printer.adjustIndent();
            this.printer.appendWithLineBreak("then");
            this.printer.increaseIndentLevel();
            for (Action action : actions) {
                this.doSwitch((EObject)action);
            }
            this.printer.decreaseIndentLevel();
        }
        this.printer.decreaseIndentLevel();
        this.printer.adjustIndent();
        this.printer.appendWithLineBreak("end");
        return true;
    }

    private void printInvariants(EList<Invariant> invariants, boolean newLine) {
        if (invariants.size() > 0) {
            if (newLine) {
                this.printer.appendLineBreak();
            }
            this.printer.appendWithLineBreak("invariants");
            this.printer.increaseIndentLevel();
            for (Invariant invariant : invariants) {
                this.doSwitch((EObject)invariant);
            }
            this.printer.decreaseIndentLevel();
        }
    }

    private void printVariants(EList<Variant> variants, boolean newLine) {
        if (variants.size() > 0) {
            if (newLine) {
                this.printer.appendLineBreak();
            }
            this.printer.appendWithLineBreak("variant");
            this.printer.increaseIndentLevel();
            for (Variant variant : variants) {
                this.doSwitch((EObject)variant);
            }
            this.printer.decreaseIndentLevel();
        }
    }

    private void printEvents(EList<Event> events, boolean newLine) {
        if (events.size() > 0) {
            if (newLine) {
                this.printer.appendLineBreak();
            }
            this.printer.appendWithLineBreak("events");
            Boolean indentEvents = (Boolean)this.printer.getPreference("indent.events", true);
            Boolean linebreakBetweenEvents = (Boolean)this.printer.getPreference("newline.between.events", true);
            if (indentEvents.booleanValue()) {
                this.printer.increaseIndentLevel();
            }
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Event event = (Event)iterator.next();
                this.doSwitch((EObject)event);
                if (!linebreakBetweenEvents.booleanValue() || !iterator.hasNext()) continue;
                this.printer.appendLineBreak();
            }
            if (indentEvents.booleanValue()) {
                this.printer.decreaseIndentLevel();
            }
        }
    }
}

