/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.prettyprint;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eventb.emf.core.EventBCommented;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.EventBNamedCommentedPredicateElement;
import org.eventb.emf.core.context.Axiom;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.context.util.ContextSwitch;
import org.eventb.texttools.Constants;
import org.eventb.texttools.prettyprint.PrettyPrintConstants;
import org.eventb.texttools.prettyprint.PrettyPrinter;

public class ContextPrintSwitch
extends ContextSwitch<Boolean>
implements PrettyPrintConstants,
Constants {
    private final PrettyPrinter printer;

    protected ContextPrintSwitch(PrettyPrinter prettyPrinter) {
        this.printer = prettyPrinter;
    }

    public Boolean caseContext(Context object) {
        this.printer.appendWithSpace("context");
        this.printer.append(object.getName());
        this.printer.appendComment((EventBCommented)object);
        EList extendsNames = object.getExtendsNames();
        if (extendsNames.size() > 0) {
            this.printer.append(' ');
            this.printer.appendWithSpace("extends");
            this.printer.appendStringList((List<String>)extendsNames);
        }
        this.printer.appendLineBreak();
        boolean newLine = (Boolean)this.printer.getPreference("newline.between.clauses", true);
        this.printer.appendNameList((EList<? extends EventBNamed>)object.getSets(), "sets", newLine);
        this.printer.appendNameList((EList<? extends EventBNamed>)object.getConstants(), "constants", newLine);
        this.printAxioms((EList<Axiom>)object.getAxioms(), newLine);
        this.printer.adjustIndent();
        this.printer.appendWithLineBreak("end");
        return true;
    }

    public Boolean caseAxiom(Axiom object) {
        this.printer.appendLabeledPredicate((EventBNamedCommentedPredicateElement)object, true);
        return true;
    }

    private void printAxioms(EList<Axiom> axioms, boolean newLine) {
        if (axioms.size() > 0) {
            if (newLine) {
                this.printer.appendLineBreak();
            }
            this.printer.appendWithLineBreak("axioms");
            this.printer.increaseIndentLevel();
            for (Axiom axiom : axioms) {
                this.doSwitch((EObject)axiom);
            }
            this.printer.decreaseIndentLevel();
        }
    }
}

