/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.formulas;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBProject;
import org.eventb.core.IMachineRoot;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IParseResult;
import org.eventb.emf.core.EventBElement;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.EventBNamedCommentedExpressionElement;
import org.eventb.emf.core.EventBNamedCommentedPredicateElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.machine.Action;
import org.eventb.emf.core.machine.Machine;
import org.eventb.emf.formulas.BExpressionResolved;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.formulas.ContextResolveSwitch;
import org.eventb.texttools.formulas.FormulaParseException;
import org.eventb.texttools.formulas.MachineResolveSwitch;
import org.eventb.texttools.formulas.ResolveVisitor;
import org.eventb.texttools.model.texttools.TextRange;
import org.rodinp.core.IRodinDB;
import org.rodinp.core.IRodinProject;
import org.rodinp.core.RodinCore;

public class FormulaResolver {
    private static FormulaFactory formulaFactory = FormulaFactory.getDefault();

    public static List<FormulaParseException> resolveAllFormulas(String projectName, EventBNamedCommentedComponentElement astRoot) {
        IRodinDB rodinDB = RodinCore.getRodinDB();
        IRodinProject rodinProject = rodinDB.getRodinProject(projectName);
        IEventBProject eventBProject = (IEventBProject)rodinProject.getAdapter(IEventBProject.class);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)astRoot, (boolean)false);
        List<FormulaParseException> exceptions = null;
        if (astRoot instanceof Machine) {
            IMachineRoot machineRoot = eventBProject.getMachineRoot(astRoot.doGetName());
            formulaFactory = machineRoot.getFormulaFactory();
            MachineResolveSwitch switcher = new MachineResolveSwitch();
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                Boolean visitChildren = (Boolean)switcher.doSwitch(next);
                if (visitChildren != null && visitChildren.booleanValue()) continue;
                iterator.prune();
            }
            exceptions = switcher.getExceptions();
        } else if (astRoot instanceof Context) {
            IContextRoot contextRoot = eventBProject.getContextRoot(astRoot.doGetName());
            formulaFactory = contextRoot.getFormulaFactory();
            ContextResolveSwitch switcher = new ContextResolveSwitch();
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                Boolean visitChildren = (Boolean)switcher.doSwitch(next);
                if (visitChildren != null && visitChildren.booleanValue()) continue;
                iterator.prune();
            }
            exceptions = switcher.getExceptions();
        }
        return exceptions;
    }

    public static void resolve(EventBNamedCommentedExpressionElement emfExpr) throws FormulaParseException {
        String expression = emfExpr.getExpression();
        FormulaResolver.resolve((EventBElement)emfExpr, expression, formulaFactory.parseExpression(expression, (Object)emfExpr), FormulaType.Expression);
    }

    public static void resolve(EventBNamedCommentedPredicateElement emfPredicate) throws FormulaParseException {
        String predicate = emfPredicate.getPredicate();
        FormulaResolver.resolve((EventBElement)emfPredicate, predicate, formulaFactory.parsePredicate(predicate, (Object)emfPredicate), FormulaType.Predicate);
    }

    public static void resolve(Action emfAction) throws FormulaParseException {
        String action = emfAction.getAction();
        FormulaResolver.resolve((EventBElement)emfAction, action, formulaFactory.parseAssignment(action, (Object)emfAction), FormulaType.Assignment);
    }

    private static void resolve(EventBElement emfExpr, String content, IParseResult parseResult, FormulaType type) throws FormulaParseException {
        List problems = parseResult.getProblems();
        if (problems.size() > 0) {
            throw new FormulaParseException(emfExpr, content, problems);
        }
        ResolveVisitor visitor = new ResolveVisitor();
        BExpressionResolved formula = null;
        int offset = FormulaResolver.getOffset(emfExpr, content);
        switch (type) {
            case Expression: {
                formula = visitor.convert(parseResult.getParsedExpression(), offset);
                break;
            }
            case Predicate: {
                formula = visitor.convert(parseResult.getParsedPredicate(), offset);
                break;
            }
            case Assignment: {
                formula = visitor.convert(parseResult.getParsedAssignment(), offset);
                break;
            }
        }
        emfExpr.getExtensions().add(formula);
    }

    private static int getOffset(EventBElement emfObject, String content) {
        TextRange range = TextPositionUtil.getInternalPosition((EventBObject)emfObject, content);
        return range != null ? range.getOffset() : 0;
    }

    private static enum FormulaType {
        Expression,
        Predicate,
        Assignment;

    }
}

