/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.diffmerge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.machine.Variant;

public class EventBEObjectMatcher
implements IEObjectMatcher {
    public void createMatches(Comparison comparison, Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, Monitor monitor) {
        Match match;
        LinkedHashSet<Match> matches = new LinkedHashSet<Match>();
        ArrayList<EObject> rightCopy = new ArrayList<EObject>();
        rightEObjects.forEachRemaining(rightCopy::add);
        ArrayList originCopy = new ArrayList();
        originEObjects.forEachRemaining(originCopy::add);
        assert (originCopy.isEmpty());
        comparison.setThreeWay(false);
        while (leftEObjects.hasNext()) {
            EObject left = leftEObjects.next();
            EObject right = this.findMatch(left, rightCopy);
            match = CompareFactory.eINSTANCE.createMatch();
            match.setLeft(left);
            match.setRight(right);
            matches.add(match);
        }
        for (EObject right : rightCopy) {
            match = CompareFactory.eINSTANCE.createMatch();
            match.setRight(right);
            matches.add(match);
        }
        comparison.getMatches().addAll(matches);
    }

    protected EObject findMatch(EObject left, List<EObject> rightCopy) {
        for (EObject candidate : rightCopy) {
            if (!EventBEObjectMatcher.matching(left, candidate)) continue;
            rightCopy.remove(candidate);
            return candidate;
        }
        return null;
    }

    public static boolean matching(EObject left, EObject candidate) {
        if (!EventBEObjectMatcher.areSameType(left, candidate)) {
            return false;
        }
        if (EventBEObjectMatcher.areVariants(left, candidate)) {
            return true;
        }
        if (left instanceof EventBNamed && candidate instanceof EventBNamed) {
            EventBNamed l = (EventBNamed)left;
            EventBNamed c = (EventBNamed)candidate;
            if (l.getName().equals(c.getName())) {
                return true;
            }
        }
        String idLeft = EventBEObjectMatcher.getEMFId(left);
        String idCandidate = EventBEObjectMatcher.getEMFId(candidate);
        return idLeft != null && idLeft.equals(idCandidate);
    }

    private static boolean areSameType(EObject obj1, EObject obj2) {
        return obj1 != null && obj2 != null && obj1.eClass().equals(obj2.eClass());
    }

    private static boolean areVariants(EObject obj1, EObject obj2) {
        return EventBEObjectMatcher.areSameType(obj1, obj2) && obj2 instanceof Variant;
    }

    private static String getEMFId(EObject eObject) {
        Resource eObjectResource;
        String functionalId;
        String identifier = eObject == null ? null : (eObject.eIsProxy() ? ((InternalEObject)eObject).eProxyURI().fragment() : ((functionalId = EcoreUtil.getID((EObject)eObject)) != null ? functionalId : ((eObjectResource = eObject.eResource()) instanceof XMIResource ? ((XMIResource)eObjectResource).getID(eObject) : null)));
        return identifier;
    }
}

