/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.outline;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eventb.emf.core.EventBObject;
import org.eventb.texteditor.ui.outline.ContextImageSwitch;
import org.eventb.texteditor.ui.outline.ContextLabelSwitch;
import org.eventb.texteditor.ui.outline.MachineImageSwitch;
import org.eventb.texteditor.ui.outline.MachineLabelSwitch;

public class OutlineLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private MachineLabelSwitch machineLabelSwitch;
    private ContextLabelSwitch contextLabelSwitch;
    private MachineImageSwitch machineImageSwitch;
    private ContextImageSwitch contextImageSwitch;

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof EventBObject) {
            EventBObject emfObject = (EventBObject)element;
            String packageNsURI = emfObject.eClass().getEPackage().getNsURI();
            if (packageNsURI.equals("http://emf.eventb.org/models/core/machine/2022")) {
                return this.getTextsForMachine(emfObject);
            }
            if (packageNsURI.equals("http://emf.eventb.org/models/core/context/2022")) {
                return this.getTextsForContext(emfObject);
            }
        }
        return new StyledString(super.getText(element));
    }

    public Image getImage(Object element) {
        if (element instanceof EventBObject) {
            EventBObject emfObject = (EventBObject)element;
            String packageNsURI = emfObject.eClass().getEPackage().getNsURI();
            if (packageNsURI.equals("http://emf.eventb.org/models/core/machine/2022")) {
                return this.getImageForMachine(emfObject);
            }
            if (packageNsURI.equals("http://emf.eventb.org/models/core/context/2022")) {
                return this.getImageForContext(emfObject);
            }
        }
        return super.getImage(element);
    }

    private Image getImageForMachine(EventBObject emfObject) {
        if (this.machineImageSwitch == null) {
            this.machineImageSwitch = new MachineImageSwitch();
        }
        return (Image)this.machineImageSwitch.doSwitch((EObject)emfObject);
    }

    private Image getImageForContext(EventBObject emfObject) {
        if (this.contextImageSwitch == null) {
            this.contextImageSwitch = new ContextImageSwitch();
        }
        return (Image)this.contextImageSwitch.doSwitch((EObject)emfObject);
    }

    private StyledString getTextsForContext(EventBObject emfObject) {
        if (this.contextLabelSwitch == null) {
            this.contextLabelSwitch = new ContextLabelSwitch();
        }
        return (StyledString)this.contextLabelSwitch.doSwitch((EObject)emfObject);
    }

    private StyledString getTextsForMachine(EventBObject emfObject) {
        if (this.machineLabelSwitch == null) {
            this.machineLabelSwitch = new MachineLabelSwitch();
        }
        return (StyledString)this.machineLabelSwitch.doSwitch((EObject)emfObject);
    }
}

