/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor.codecompletion;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texteditor.ui.editor.codecompletion.EditorSynchronizer;
import org.eventb.texteditor.ui.editor.codecompletion.IRelevantProposal;
import org.eventb.texteditor.ui.editor.codecompletion.PositionBasedCompletionProposal;

public class EventBTemplateProposal
extends TemplateProposal
implements IRelevantProposal,
ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private final IRegion fRegion;
    private IRegion fSelectedRegion;
    private InclusivePositionUpdater fUpdater;

    public EventBTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
        this.fRegion = region;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            TemplateBuffer templateBuffer;
            TemplateContext fContext = this.getContext();
            fContext.setReadOnly(false);
            int oldReplaceOffset = this.getReplaceOffset();
            try {
                templateBuffer = fContext.evaluate(this.getTemplate());
            }
            catch (TemplateException templateException) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            int start = this.getReplaceOffset();
            int shift = start - oldReplaceOffset;
            int end = Math.max(this.getReplaceEndOffset(), offset + shift);
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                if (!variable.isUnambiguous()) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    String[] values = variable.getValues();
                    ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                    int j = 0;
                    while (j < values.length) {
                        this.ensurePositionCategoryInstalled(document, model);
                        Position pos = new Position(offsets[0] + start, length);
                        document.addPosition(this.getCategory(), pos);
                        proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                        ++j;
                    }
                    Object first = proposals.length > 1 ? new ProposalPosition(document, offsets[0] + start, length, proposals) : new LinkedPosition(document, offsets[0] + start, length);
                    int j2 = 0;
                    while (j2 != offsets.length) {
                        if (j2 == 0) {
                            group.addPosition(first);
                        } else {
                            group.addPosition(new LinkedPosition(document, offsets[j2] + start, length));
                        }
                        ++j2;
                    }
                    model.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                model.forceInstall();
                EventBTextEditor editor = this.getEventBEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(document);
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.ensurePositionCategoryRemoved(document);
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private EventBTextEditor getEventBEditor() {
        IEditorPart part = TextEditorPlugin.getPlugin().getActivePage().getActiveEditor();
        if (part instanceof EventBTextEditor) {
            return (EventBTextEditor)part;
        }
        return null;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    EventBTemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)"Template Evaluation Error", (String)e.getMessage());
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }
}

