/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor;

import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eventb.core.IExtendsContext;
import org.eventb.core.IRefinesEvent;
import org.eventb.core.IRefinesMachine;
import org.eventb.core.ISeesContext;
import org.eventb.emf.core.EventBExpression;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.EventBPredicate;
import org.eventb.emf.core.machine.Action;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Parameter;
import org.eventb.emf.core.machine.Variable;
import org.eventb.emf.persistence.factory.RodinResource;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.model.texttools.TextRange;
import org.rodinp.core.IInternalElement;
import org.rodinp.core.RodinDBException;
import org.rodinp.core.RodinMarkerUtil;

public class AnnotationModel
extends AbstractMarkerAnnotationModel {
    private static final String LABEL_ATTRIBUTE_ID = "org.eventb.core.label";
    private final RodinResource rodinResource;
    private final IResource fResource;
    private final IWorkspace fWorkspace;
    private final IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();

    protected void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        if (markerDeltas.length == 1) {
            IMarkerDelta delta = markerDeltas[0];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                }
            }
        } else {
            this.batchedUpdate(markerDeltas);
        }
        this.fireModelChanged();
    }

    private void batchedUpdate(IMarkerDelta[] markerDeltas) {
        HashSet<IMarker> removedMarkers = new HashSet<IMarker>(markerDeltas.length);
        HashSet<IMarker> modifiedMarkers = new HashSet<IMarker>(markerDeltas.length);
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta delta = markerDeltas[i];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    removedMarkers.add(delta.getMarker());
                    break;
                }
                case 4: {
                    modifiedMarkers.add(delta.getMarker());
                }
            }
            ++i;
        }
    }

    public AnnotationModel(IResource fileResource, Resource emfResource) {
        Assert.isNotNull((Object)fileResource);
        this.fResource = fileResource;
        this.fWorkspace = fileResource.getWorkspace();
        this.rodinResource = emfResource instanceof RodinResource ? (RodinResource)emfResource : null;
    }

    protected Position createPositionFromMarker(IMarker marker) {
        try {
            if ("org.rodinp.core.problem".equals(marker.getType())) {
                return this.createPosition(marker);
            }
        }
        catch (CoreException e) {
            TextEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eventb.texteditor.ui", "Error analyzing marker", (Throwable)e));
        }
        return super.createPositionFromMarker(marker);
    }

    private Position createPosition(IMarker marker) {
        IRegion region = this.getBestRegion(marker);
        if (region != null) {
            return new Position(region.getOffset(), region.getLength());
        }
        return null;
    }

    private IRegion getBestRegion(IMarker marker) {
        int charStart = RodinMarkerUtil.getCharStart((IMarker)marker);
        int charEnd = RodinMarkerUtil.getCharEnd((IMarker)marker);
        IInternalElement rodinElement = RodinMarkerUtil.getInternalElement((IMarker)marker);
        if (this.isReferenceElement(rodinElement)) {
            return this.handleReferenceElement(rodinElement);
        }
        EventBObject eventBObject = (EventBObject)this.rodinResource.getMap().get(rodinElement);
        if (charStart >= 0 && charEnd >= 0) {
            return this.getRegionInFormula(eventBObject, charStart, charEnd);
        }
        if (this.onlyLabelIsRelevant(marker, eventBObject)) {
            TextRange range = TextPositionUtil.getInternalPosition((EventBObject)eventBObject, (String)((EventBNamed)eventBObject).getName());
            if (range != null) {
                return new Region(range.getOffset(), range.getLength());
            }
        } else {
            TextRange range = TextPositionUtil.getTextRange((EventBObject)eventBObject);
            if (range != null) {
                return new Region(range.getOffset(), range.getLength());
            }
        }
        return new Region(0, 0);
    }

    private boolean isReferenceElement(IInternalElement rodinElement) {
        return rodinElement instanceof IRefinesEvent || rodinElement instanceof ISeesContext || rodinElement instanceof IRefinesMachine || rodinElement instanceof IExtendsContext;
    }

    private IRegion handleReferenceElement(IInternalElement rodinElement) {
        EventBObject parent = (EventBObject)this.rodinResource.getMap().get(rodinElement.getParent());
        if (parent != null) {
            String name = null;
            try {
                if (rodinElement instanceof IRefinesEvent) {
                    name = ((IRefinesEvent)rodinElement).getAbstractEventLabel();
                } else if (rodinElement instanceof ISeesContext) {
                    name = ((ISeesContext)rodinElement).getSeenContextName();
                } else if (rodinElement instanceof IRefinesMachine) {
                    name = ((IRefinesMachine)rodinElement).getAbstractMachineName();
                } else if (rodinElement instanceof IExtendsContext) {
                    name = ((IExtendsContext)rodinElement).getAbstractContextName();
                }
                TextRange range = TextPositionUtil.getInternalPosition((EventBObject)parent, (String)name);
                if (range != null) {
                    return new Region(range.getOffset(), range.getLength());
                }
            }
            catch (RodinDBException rodinDBException) {}
        }
        return new Region(0, 0);
    }

    private boolean onlyLabelIsRelevant(IMarker marker, EventBObject eventBObject) {
        String attributeId = marker.getAttribute("attributeId", null);
        if (LABEL_ATTRIBUTE_ID.equals(attributeId) && eventBObject instanceof EventBNamed) {
            return true;
        }
        if (eventBObject instanceof Event) {
            return true;
        }
        return eventBObject instanceof Variable || eventBObject instanceof Parameter;
    }

    private IRegion getRegionInFormula(EventBObject eventBObject, int charStart, int charEnd) {
        TextRange range = null;
        if (eventBObject instanceof EventBPredicate) {
            range = TextPositionUtil.getInternalPosition((EventBObject)eventBObject, (String)((EventBPredicate)eventBObject).getPredicate());
        } else if (eventBObject instanceof Action) {
            range = TextPositionUtil.getInternalPosition((EventBObject)eventBObject, (String)((Action)eventBObject).getAction());
        } else if (eventBObject instanceof EventBExpression) {
            range = TextPositionUtil.getInternalPosition((EventBObject)eventBObject, (String)((EventBExpression)eventBObject).getExpression());
        }
        if (range != null) {
            return new Region(range.getOffset() + charStart, charEnd - charStart);
        }
        range = TextPositionUtil.getTextRange((EventBObject)eventBObject);
        if (range != null) {
            return new Region(range.getOffset(), range.getLength());
        }
        return null;
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null, 1, null);
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        return this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker != null && this.fResource.equals((Object)marker.getResource());
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta child;
            IResourceDelta delta = e.getDelta();
            if (delta != null && AnnotationModel.this.fResource != null && (child = delta.findMember(AnnotationModel.this.fResource.getFullPath())) != null) {
                AnnotationModel.this.update(child.getMarkerDeltas());
            }
        }
    }
}

