/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.ast;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eventb.texteditor.ui.build.ast.IParseProblemWrapper;
import org.eventb.texttools.ParseException;

public class ParseExceptionWrapperDiagnostic
implements IParseProblemWrapper {
    private final ParseException exception;
    private final IDocument document;

    public ParseExceptionWrapperDiagnostic(IDocument document, ParseException e) {
        this.document = document;
        this.exception = e;
    }

    @Override
    public int getColumn() {
        return this.exception.getPosition();
    }

    @Override
    public int getLine() {
        return this.exception.getLine();
    }

    @Override
    public int getOffset() {
        try {
            return this.document.getLineOffset(this.getLine()) + this.getColumn();
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    @Override
    public int getTokenLength() {
        return this.exception.getTokenLength();
    }

    @Override
    public String getToken() {
        try {
            return this.document.get(this.getOffset(), this.getTokenLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    @Override
    public String getMessage() {
        return this.exception.getLocalizedMessage();
    }
}

