/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools;

import de.be4.eventb.core.parser.BException;
import de.be4.eventb.core.parser.EventBLexerException;
import de.be4.eventb.core.parser.EventBParseException;
import de.be4.eventb.core.parser.EventBParser;
import de.be4.eventb.core.parser.node.Node;
import de.be4.eventb.core.parser.node.Start;
import de.be4.eventb.core.parser.node.Token;
import de.be4.eventb.core.parser.parser.ParserException;
import de.hhu.stups.sablecc.patch.SourcePositions;
import de.hhu.stups.sablecc.patch.SourcecodeRange;
import org.eclipse.jface.text.IDocument;
import org.eventb.emf.core.EventBObject;
import org.eventb.texttools.ParseException;
import org.eventb.texttools.internal.parsing.TransformationVisitor;

public class Parser {
    private final EventBParser parser = new EventBParser();
    private final TransformationVisitor transformer = new TransformationVisitor();

    public <T extends EventBObject> T parse(IDocument document) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Parser may not be called without input document");
        }
        String input = document.get();
        try {
            Start rootNode = this.parser.parse(input, false);
            Object transform = this.transformer.transform((Node)rootNode, document);
            return transform;
        }
        catch (BException e) {
            Exception cause = e.getCause();
            if (cause instanceof ParserException) {
                ParserException ex = (ParserException)cause;
                Token token = ex.getToken();
                throw new ParseException(this.adjustMessage(ex.getLocalizedMessage()), token.getLine() - 1, token.getPos() - 1, token.getText().length());
            }
            if (cause instanceof EventBLexerException) {
                EventBLexerException ex = (EventBLexerException)cause;
                String lastText = ex.getLastText();
                throw new ParseException(this.adjustMessage(ex.getLocalizedMessage()), ex.getLastLine() - 1, ex.getLastPos() - 1, lastText.length());
            }
            if (cause instanceof EventBParseException) {
                EventBParseException ex = (EventBParseException)cause;
                SourcecodeRange range = ex.getRange();
                SourcePositions positions = this.parser.getSourcePositions();
                if (range != null && positions != null) {
                    throw new ParseException(this.adjustMessage(ex.getLocalizedMessage()), positions.getBeginLine(range) - 1, positions.getBeginColumn(range) - 1, positions.getRangeString(range).length());
                }
                Token token = ex.getToken();
                if (token != null) {
                    throw new ParseException(this.adjustMessage(ex.getLocalizedMessage()), token.getLine() - 1, token.getPos() - 1, token.getText().length());
                }
            }
            throw new ParseException(e.getLocalizedMessage(), 0, 0, 1);
        }
    }

    private String adjustMessage(String localizedMessage) {
        StringBuilder result = new StringBuilder(localizedMessage);
        int posEnd = result.indexOf("] ");
        if (result.charAt(0) == '[' && posEnd > 0) {
            result.delete(0, posEnd + 2);
        }
        result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        return result.toString().trim();
    }
}

