/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.formulas;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.formulas.BAssignmentResolved;
import org.eventb.emf.formulas.BExpressionResolved;
import org.eventb.emf.formulas.BFormula;
import org.eventb.emf.formulas.BPredicateResolved;
import org.eventb.emf.formulas.BecomesEqualToAssignment;
import org.eventb.emf.formulas.BecomesMemberOfAssignment;
import org.eventb.emf.formulas.BecomesSuchThatAssignment;
import org.eventb.emf.formulas.BinaryOperator;
import org.eventb.emf.formulas.BoundIdentifierExpression;
import org.eventb.emf.formulas.Constant;
import org.eventb.emf.formulas.ExistPredicate;
import org.eventb.emf.formulas.ForallPredicate;
import org.eventb.emf.formulas.FormulasFactory;
import org.eventb.emf.formulas.FormulasPackage;
import org.eventb.emf.formulas.IdentifierExpression;
import org.eventb.emf.formulas.IntegerLiteralExpression;
import org.eventb.emf.formulas.MultiOperand;
import org.eventb.emf.formulas.QuantifiedUnionExpression1;
import org.eventb.emf.formulas.UnaryOperator;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.TextToolsPlugin;

public class ResolveVisitor
implements ISimpleVisitor {
    private static final Map<Integer, EClass> idToEClass = new HashMap<Integer, EClass>();
    private Map<BFormula, Formula> emfToRodinElements;
    private final Stack<BFormula> stack = new Stack();
    private final Stack<List<String>> boundIdDeclStack = new Stack();
    private int textOffset;

    static {
        idToEClass.put(401, FormulasPackage.eINSTANCE.getINT());
        idToEClass.put(402, FormulasPackage.eINSTANCE.getNAT());
        idToEClass.put(403, FormulasPackage.eINSTANCE.getNAT1());
        idToEClass.put(404, FormulasPackage.eINSTANCE.getBOOL());
        idToEClass.put(405, FormulasPackage.eINSTANCE.getTRUE());
        idToEClass.put(610, FormulasPackage.eINSTANCE.getTRUTH());
        idToEClass.put(406, FormulasPackage.eINSTANCE.getFALSE());
        idToEClass.put(611, FormulasPackage.eINSTANCE.getFALSITY());
        idToEClass.put(407, FormulasPackage.eINSTANCE.getEMPTYSET());
        idToEClass.put(408, FormulasPackage.eINSTANCE.getPredExpression());
        idToEClass.put(409, FormulasPackage.eINSTANCE.getSuccExpression());
        idToEClass.put(751, FormulasPackage.eINSTANCE.getCardExpression());
        idToEClass.put(752, FormulasPackage.eINSTANCE.getPowExpression());
        idToEClass.put(753, FormulasPackage.eINSTANCE.getPow1Expression());
        idToEClass.put(754, FormulasPackage.eINSTANCE.getKUnionExpression());
        idToEClass.put(755, FormulasPackage.eINSTANCE.getKIntersectionExpression());
        idToEClass.put(756, FormulasPackage.eINSTANCE.getDomainExpression());
        idToEClass.put(757, FormulasPackage.eINSTANCE.getRangeExpression());
        idToEClass.put(758, FormulasPackage.eINSTANCE.getPrj1Expression());
        idToEClass.put(410, FormulasPackage.eINSTANCE.getPrj1GenExpression());
        idToEClass.put(759, FormulasPackage.eINSTANCE.getPrj2Expression());
        idToEClass.put(411, FormulasPackage.eINSTANCE.getPrj2GenExpression());
        idToEClass.put(760, FormulasPackage.eINSTANCE.getIdentityExpression());
        idToEClass.put(412, FormulasPackage.eINSTANCE.getIdentityGenExpression());
        idToEClass.put(761, FormulasPackage.eINSTANCE.getMinExpression());
        idToEClass.put(762, FormulasPackage.eINSTANCE.getMaxExpression());
        idToEClass.put(763, FormulasPackage.eINSTANCE.getInverseExpression());
        idToEClass.put(764, FormulasPackage.eINSTANCE.getUnaryMinusExpression());
        idToEClass.put(701, FormulasPackage.eINSTANCE.getNotPredicate());
        idToEClass.put(620, FormulasPackage.eINSTANCE.getFinitePredicate());
        idToEClass.put(601, FormulasPackage.eINSTANCE.getBoolExpression());
        idToEClass.put(101, FormulasPackage.eINSTANCE.getEqualPredicate());
        idToEClass.put(102, FormulasPackage.eINSTANCE.getNotEqualPredicate());
        idToEClass.put(103, FormulasPackage.eINSTANCE.getLessPredicate());
        idToEClass.put(104, FormulasPackage.eINSTANCE.getLessEqualPredicate());
        idToEClass.put(105, FormulasPackage.eINSTANCE.getGreaterPredicate());
        idToEClass.put(106, FormulasPackage.eINSTANCE.getGreaterEqualPredicate());
        idToEClass.put(107, FormulasPackage.eINSTANCE.getBelongPredicate());
        idToEClass.put(108, FormulasPackage.eINSTANCE.getNotBelongPredicate());
        idToEClass.put(109, FormulasPackage.eINSTANCE.getSubsetStrictPredicate());
        idToEClass.put(110, FormulasPackage.eINSTANCE.getNotSubsetStrictPredicate());
        idToEClass.put(111, FormulasPackage.eINSTANCE.getSubsetPredicate());
        idToEClass.put(112, FormulasPackage.eINSTANCE.getNotSubsetPredicate());
        idToEClass.put(201, FormulasPackage.eINSTANCE.getMapletExpression());
        idToEClass.put(202, FormulasPackage.eINSTANCE.getRelationExpression());
        idToEClass.put(203, FormulasPackage.eINSTANCE.getTotalRelationExpression());
        idToEClass.put(204, FormulasPackage.eINSTANCE.getSurjectiveRelationExpression());
        idToEClass.put(205, FormulasPackage.eINSTANCE.getTotalSurjectiveRelationExpression());
        idToEClass.put(206, FormulasPackage.eINSTANCE.getPartialFunctionExpression());
        idToEClass.put(207, FormulasPackage.eINSTANCE.getTotalFunctionExpression());
        idToEClass.put(208, FormulasPackage.eINSTANCE.getPartialInjectionExpression());
        idToEClass.put(209, FormulasPackage.eINSTANCE.getTotalInjectionExpression());
        idToEClass.put(210, FormulasPackage.eINSTANCE.getPartialSurjectionExpression());
        idToEClass.put(211, FormulasPackage.eINSTANCE.getTotalSurjectionExpression());
        idToEClass.put(212, FormulasPackage.eINSTANCE.getTotalBijectionExpression());
        idToEClass.put(213, FormulasPackage.eINSTANCE.getSetSubtractionExpression());
        idToEClass.put(214, FormulasPackage.eINSTANCE.getCartesianProductExpression());
        idToEClass.put(215, FormulasPackage.eINSTANCE.getDirectProductExpression());
        idToEClass.put(216, FormulasPackage.eINSTANCE.getParallelProductExpression());
        idToEClass.put(217, FormulasPackage.eINSTANCE.getDomainRestrictionExpression());
        idToEClass.put(218, FormulasPackage.eINSTANCE.getDomainSubtractionExpression());
        idToEClass.put(219, FormulasPackage.eINSTANCE.getRangeRestrictionExpression());
        idToEClass.put(220, FormulasPackage.eINSTANCE.getRangeSubtractionExpression());
        idToEClass.put(221, FormulasPackage.eINSTANCE.getUptoExpression());
        idToEClass.put(222, FormulasPackage.eINSTANCE.getSubtractExpression());
        idToEClass.put(223, FormulasPackage.eINSTANCE.getDivisionExpression());
        idToEClass.put(224, FormulasPackage.eINSTANCE.getModuloExpression());
        idToEClass.put(225, FormulasPackage.eINSTANCE.getExponentiationExpression());
        idToEClass.put(226, FormulasPackage.eINSTANCE.getFunctionExpression());
        idToEClass.put(227, FormulasPackage.eINSTANCE.getImageExpression());
        idToEClass.put(251, FormulasPackage.eINSTANCE.getImplicationPredicate());
        idToEClass.put(252, FormulasPackage.eINSTANCE.getEquivalencePredicate());
        idToEClass.put(301, FormulasPackage.eINSTANCE.getUnionExpression());
        idToEClass.put(302, FormulasPackage.eINSTANCE.getIntersectionExpression());
        idToEClass.put(303, FormulasPackage.eINSTANCE.getBackwardCompositionExpression());
        idToEClass.put(304, FormulasPackage.eINSTANCE.getForwardCompositionExpression());
        idToEClass.put(305, FormulasPackage.eINSTANCE.getRelationalOverridingExpression());
        idToEClass.put(306, FormulasPackage.eINSTANCE.getAddExpression());
        idToEClass.put(307, FormulasPackage.eINSTANCE.getMulExpression());
        idToEClass.put(351, FormulasPackage.eINSTANCE.getAndPredicate());
        idToEClass.put(352, FormulasPackage.eINSTANCE.getOrPredicate());
        idToEClass.put(5, FormulasPackage.eINSTANCE.getSetExpression());
        idToEClass.put(901, FormulasPackage.eINSTANCE.getPartitionPredicate());
        idToEClass.put(851, FormulasPackage.eINSTANCE.getForallPredicate());
        idToEClass.put(852, FormulasPackage.eINSTANCE.getExistPredicate());
    }

    public BExpressionResolved convert(Expression rodinExpr, int offset) {
        this.traverseFormula((Formula)rodinExpr, offset);
        return (BExpressionResolved)this.stack.pop();
    }

    public BPredicateResolved convert(Predicate predicate, int offset) {
        this.traverseFormula((Formula)predicate, offset);
        return (BPredicateResolved)this.stack.pop();
    }

    public BAssignmentResolved convert(Assignment assignment, int offset) {
        this.traverseFormula((Formula)assignment, offset);
        return (BAssignmentResolved)this.stack.pop();
    }

    private void traverseFormula(Formula rodinFormula, int offset) {
        this.emfToRodinElements = new HashMap<BFormula, Formula>();
        this.textOffset = offset;
        rodinFormula.accept((ISimpleVisitor)this);
        assert (this.stack.size() == 1);
    }

    private void storeNode(BFormula node, Formula rodinFormula) {
        this.annotatePosition(node, rodinFormula);
        this.emfToRodinElements.put(node, rodinFormula);
        this.stack.push(node);
    }

    public Map<BFormula, Formula> getEmfToRodinMapping() {
        return this.emfToRodinElements;
    }

    public void visitAssociativeExpression(AssociativeExpression expression) {
        this.handleMultiChildren((Formula)expression, (Formula[])expression.getChildren());
    }

    public void visitAssociativePredicate(AssociativePredicate predicate) {
        this.handleMultiChildren((Formula)predicate, (Formula[])predicate.getChildren());
    }

    public void visitAtomicExpression(AtomicExpression expression) {
        EClass eClass = this.getMatchingEClass((Formula)expression);
        EObject eObject = FormulasFactory.eINSTANCE.create(eClass);
        this.storeNode((BFormula)eObject, (Formula)expression);
    }

    public void visitBecomesEqualTo(BecomesEqualTo assignment) {
        FreeIdentifier[] identifiers = assignment.getAssignedIdentifiers();
        this.visitChildren((Formula[])identifiers);
        Expression[] expressions = assignment.getExpressions();
        this.visitChildren((Formula[])expressions);
        BecomesEqualToAssignment newNode = FormulasFactory.eINSTANCE.createBecomesEqualToAssignment();
        EList exprChildren = newNode.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            exprChildren.add(0, (Object)((BExpressionResolved)this.stack.pop()));
            ++i;
        }
        EList identChildren = newNode.getIdentifiers();
        int i2 = 0;
        while (i2 < identifiers.length) {
            identChildren.add(0, (Object)((IdentifierExpression)this.stack.pop()));
            ++i2;
        }
        this.storeNode((BFormula)newNode, (Formula)assignment);
    }

    public void visitBecomesMemberOf(BecomesMemberOf assignment) {
        FreeIdentifier[] identifiers = assignment.getAssignedIdentifiers();
        this.visitChildren((Formula[])identifiers);
        Expression expression = assignment.getSet();
        this.visitChildren((Formula)expression);
        BecomesMemberOfAssignment newNode = FormulasFactory.eINSTANCE.createBecomesMemberOfAssignment();
        newNode.setExpression((BExpressionResolved)this.stack.pop());
        EList identChildren = newNode.getIdentifiers();
        int i = 0;
        while (i < identifiers.length) {
            identChildren.add(0, (Object)((IdentifierExpression)this.stack.pop()));
            ++i;
        }
        this.storeNode((BFormula)newNode, (Formula)assignment);
    }

    public void visitBecomesSuchThat(BecomesSuchThat assignment) {
        FreeIdentifier[] identifiers = assignment.getAssignedIdentifiers();
        this.visitChildren((Formula[])identifiers);
        LinkedList<String> primedIdents = new LinkedList<String>();
        int i = 0;
        while (i < identifiers.length) {
            primedIdents.add(String.valueOf(identifiers[i].getName()) + "'");
            ++i;
        }
        this.boundIdDeclStack.push(primedIdents);
        Predicate predicate = assignment.getCondition();
        this.visitChildren((Formula)predicate);
        this.boundIdDeclStack.pop();
        BecomesSuchThatAssignment newNode = FormulasFactory.eINSTANCE.createBecomesSuchThatAssignment();
        newNode.setPredicate((BPredicateResolved)this.stack.pop());
        EList identChildren = newNode.getIdentifiers();
        int i2 = 0;
        while (i2 < identifiers.length) {
            identChildren.add(0, (Object)((IdentifierExpression)this.stack.pop()));
            ++i2;
        }
        this.storeNode((BFormula)newNode, (Formula)assignment);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.handleTwoChildren((Formula)expression, (Formula)expression.getLeft(), (Formula)expression.getRight());
    }

    public void visitBinaryPredicate(BinaryPredicate predicate) {
        this.handleTwoChildren((Formula)predicate, (Formula)predicate.getLeft(), (Formula)predicate.getRight());
    }

    public void visitBoolExpression(BoolExpression expression) {
        this.handleSingleChild((Formula)expression, (Formula)expression.getPredicate());
    }

    public void visitBoundIdentDecl(BoundIdentDecl boundIdentDecl) {
        BoundIdentifierExpression node = FormulasFactory.eINSTANCE.createBoundIdentifierExpression();
        node.setName(boundIdentDecl.getName());
        this.storeNode((BFormula)node, (Formula)boundIdentDecl);
    }

    public void visitBoundIdentifier(BoundIdentifier identifierExpression) {
        BoundIdentifierExpression node = FormulasFactory.eINSTANCE.createBoundIdentifierExpression();
        List<String> identDecls = this.boundIdDeclStack.peek();
        int index = identifierExpression.getBoundIndex();
        String name = identDecls.get(index);
        node.setName(name);
        this.storeNode((BFormula)node, (Formula)identifierExpression);
    }

    public void visitFreeIdentifier(FreeIdentifier identifierExpression) {
        IdentifierExpression node = FormulasFactory.eINSTANCE.createIdentifierExpression();
        node.setName(identifierExpression.getName());
        this.storeNode((BFormula)node, (Formula)identifierExpression);
    }

    public void visitIntegerLiteral(IntegerLiteral expression) {
        IntegerLiteralExpression node = FormulasFactory.eINSTANCE.createIntegerLiteralExpression();
        node.setNumber(expression.getValue());
        this.storeNode((BFormula)node, (Formula)expression);
    }

    public void visitLiteralPredicate(LiteralPredicate predicate) {
        Constant node = (Constant)FormulasFactory.eINSTANCE.create(this.getMatchingEClass((Formula)predicate));
        this.storeNode((BFormula)node, (Formula)predicate);
    }

    public void visitMultiplePredicate(MultiplePredicate predicate) {
        this.handleMultiChildren((Formula)predicate, (Formula[])predicate.getChildren());
    }

    public void visitQuantifiedExpression(QuantifiedExpression expression) {
        BoundIdentDecl[] localIdentifiers = expression.getBoundIdentDecls();
        this.boundIdDeclStack.push(this.convertIdentDecl(localIdentifiers));
        BoundIdentDecl[] boundIdentDeclArray = localIdentifiers;
        int n = localIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            BoundIdentDecl boundIdentDecl = boundIdentDeclArray[n2];
            boundIdentDecl.accept((ISimpleVisitor)this);
            ++n2;
        }
        expression.getPredicate().accept((ISimpleVisitor)this);
        expression.getExpression().accept((ISimpleVisitor)this);
        this.boundIdDeclStack.pop();
        boolean isFullType = localIdentifiers.length > 0;
        QuantifiedUnionExpression1 node = null;
        EList identifiers = null;
        switch (expression.getTag()) {
            case 801: {
                QuantifiedUnionExpression1 newNode;
                if (isFullType) {
                    newNode = FormulasFactory.eINSTANCE.createQuantifiedUnionExpression1();
                    newNode.setExpression((BExpressionResolved)this.stack.pop());
                    newNode.setPredicate((BPredicateResolved)this.stack.pop());
                    identifiers = newNode.getIdentifiers();
                    node = newNode;
                    break;
                }
                newNode = FormulasFactory.eINSTANCE.createQuantifiedUnionExpression2();
                newNode.setExpression((BExpressionResolved)this.stack.pop());
                newNode.setPredicate((BPredicateResolved)this.stack.pop());
                node = newNode;
                break;
            }
            case 802: {
                QuantifiedUnionExpression1 newNode;
                if (isFullType) {
                    newNode = FormulasFactory.eINSTANCE.createQuantifiedIntersectionExpression1();
                    newNode.setExpression((BExpressionResolved)this.stack.pop());
                    newNode.setPredicate((BPredicateResolved)this.stack.pop());
                    identifiers = newNode.getIdentifiers();
                    node = newNode;
                    break;
                }
                newNode = FormulasFactory.eINSTANCE.createQuantifiedIntersectionExpression2();
                newNode.setExpression((BExpressionResolved)this.stack.pop());
                newNode.setPredicate((BPredicateResolved)this.stack.pop());
                node = newNode;
                break;
            }
            case 803: {
                QuantifiedUnionExpression1 newNode;
                if (isFullType) {
                    newNode = FormulasFactory.eINSTANCE.createSetComprehensionExpression1();
                    newNode.setExpression((BExpressionResolved)this.stack.pop());
                    newNode.setPredicate((BPredicateResolved)this.stack.pop());
                    identifiers = newNode.getIdentifiers();
                    node = newNode;
                    break;
                }
                newNode = FormulasFactory.eINSTANCE.createSetComprehensionExpression2();
                newNode.setExpression((BExpressionResolved)this.stack.pop());
                newNode.setPredicate((BPredicateResolved)this.stack.pop());
                node = newNode;
                break;
            }
        }
        int i = 0;
        while (i < localIdentifiers.length) {
            identifiers.add(0, (Object)((IdentifierExpression)this.stack.pop()));
            ++i;
        }
        this.storeNode((BFormula)node, (Formula)expression);
    }

    public void visitQuantifiedPredicate(QuantifiedPredicate predicate) {
        BoundIdentDecl[] localIdentifiers = predicate.getBoundIdentDecls();
        this.boundIdDeclStack.push(this.convertIdentDecl(localIdentifiers));
        BoundIdentDecl[] boundIdentDeclArray = localIdentifiers;
        int n = localIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            BoundIdentDecl boundIdentDecl = boundIdentDeclArray[n2];
            boundIdentDecl.accept((ISimpleVisitor)this);
            ++n2;
        }
        predicate.getPredicate().accept((ISimpleVisitor)this);
        this.boundIdDeclStack.pop();
        BFormula node = (BFormula)FormulasFactory.eINSTANCE.create(this.getMatchingEClass((Formula)predicate));
        EList identifiers = null;
        switch (predicate.getTag()) {
            case 851: {
                ForallPredicate forallPred = (ForallPredicate)node;
                identifiers = forallPred.getIdentifiers();
                forallPred.setPredicate((BPredicateResolved)this.stack.pop());
                break;
            }
            case 852: {
                ExistPredicate existPred = (ExistPredicate)node;
                identifiers = existPred.getIdentifiers();
                existPred.setPredicate((BPredicateResolved)this.stack.pop());
                break;
            }
        }
        int i = 0;
        while (i < localIdentifiers.length) {
            identifiers.add(0, (Object)((BoundIdentifierExpression)this.stack.pop()));
            ++i;
        }
        this.storeNode(node, (Formula)predicate);
    }

    public void visitRelationalPredicate(RelationalPredicate predicate) {
        this.handleTwoChildren((Formula)predicate, (Formula)predicate.getLeft(), (Formula)predicate.getRight());
    }

    public void visitSetExtension(SetExtension expression) {
        this.handleMultiChildren((Formula)expression, (Formula[])expression.getMembers());
    }

    public void visitSimplePredicate(SimplePredicate predicate) {
        this.handleSingleChild((Formula)predicate, (Formula)predicate.getExpression());
    }

    public void visitUnaryExpression(UnaryExpression expression) {
        this.handleSingleChild((Formula)expression, (Formula)expression.getChild());
    }

    public void visitUnaryPredicate(UnaryPredicate predicate) {
        this.handleSingleChild((Formula)predicate, (Formula)predicate.getChild());
    }

    public void visitExtendedExpression(ExtendedExpression expression) {
        Formula[] children = new Formula[expression.getChildCount()];
        int i = 0;
        while (i < expression.getChildCount()) {
            children[i] = expression.getChild(i);
            ++i;
        }
        this.handleMultiChildren((Formula)expression, children);
    }

    public void visitExtendedPredicate(ExtendedPredicate predicate) {
        Formula[] children = new Formula[predicate.getChildCount()];
        int i = 0;
        while (i < predicate.getChildCount()) {
            children[i] = predicate.getChild(i);
            ++i;
        }
        this.handleMultiChildren((Formula)predicate, children);
    }

    private void handleSingleChild(Formula rodinNode, Formula child) {
        child.accept((ISimpleVisitor)this);
        UnaryOperator node = (UnaryOperator)FormulasFactory.eINSTANCE.create(this.getMatchingEClass(rodinNode));
        node.setChild(this.stack.pop());
        this.storeNode((BFormula)node, rodinNode);
    }

    private void handleTwoChildren(Formula rodinNode, Formula leftChild, Formula rightChild) {
        this.visitChildren(leftChild);
        this.visitChildren(rightChild);
        BinaryOperator node = (BinaryOperator)FormulasFactory.eINSTANCE.create(this.getMatchingEClass(rodinNode));
        node.setRight(this.stack.pop());
        node.setLeft(this.stack.pop());
        this.storeNode((BFormula)node, rodinNode);
    }

    private void handleMultiChildren(Formula rodinNode, Formula[] rodinChildren) {
        this.visitChildren(rodinChildren);
        MultiOperand node = (MultiOperand)FormulasFactory.eINSTANCE.create(this.getMatchingEClass(rodinNode));
        EList children = node.getChildren();
        int i = 0;
        while (i < rodinChildren.length) {
            children.add(0, (Object)this.stack.pop());
            ++i;
        }
        this.storeNode((BFormula)node, rodinNode);
    }

    private void visitChildren(Formula[] rodinChildren) {
        Formula[] formulaArray = rodinChildren;
        int n = rodinChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Formula child = formulaArray[n2];
            child.accept((ISimpleVisitor)this);
            ++n2;
        }
    }

    private void visitChildren(Formula child) {
        child.accept((ISimpleVisitor)this);
    }

    private List<String> convertIdentDecl(BoundIdentDecl[] identDecl) {
        LinkedList<String> result = null;
        result = !this.boundIdDeclStack.isEmpty() ? new LinkedList(this.boundIdDeclStack.peek()) : new LinkedList<String>();
        int i = 0;
        while (i < identDecl.length) {
            result.addFirst(identDecl[i].getName());
            ++i;
        }
        return result;
    }

    private void annotatePosition(BFormula node, Formula rodinFormula) {
        SourceLocation location = rodinFormula.getSourceLocation();
        if (location != null) {
            int startPos = location.getStart();
            int endPos = location.getEnd();
            TextPositionUtil.annotatePosition((EventBObject)node, this.textOffset + startPos, endPos - startPos + 1);
        }
    }

    private EClass getMatchingEClass(Formula formula) {
        int tag = formula.getTag();
        EClass eClass = null;
        if (tag < 1000) {
            eClass = idToEClass.get(formula.getTag());
            if (eClass == null) {
                String message = "Unknown Rodin formula type: [" + formula.getTag() + "] " + formula.toString();
                TextToolsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eventb.texttools", message));
                throw new UnsupportedOperationException(message);
            }
        } else {
            eClass = formula instanceof Expression ? FormulasPackage.eINSTANCE.getExtendedExpression() : FormulasPackage.eINSTANCE.getExtendedPredicate();
        }
        return eClass;
    }
}

