/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools;

import de.be4.eventb.core.parser.BException;
import de.be4.eventb.core.parser.EventBParser;
import de.be4.eventb.core.parser.node.AContextParseUnit;
import de.be4.eventb.core.parser.node.AMachineParseUnit;
import de.be4.eventb.core.parser.node.PParseUnit;
import de.be4.eventb.core.parser.node.Start;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eventb.emf.core.Attribute;
import org.eventb.emf.core.AttributeType;
import org.eventb.emf.core.CoreFactory;
import org.eventb.emf.core.EventBElement;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.texttools.TextToolsPlugin;
import org.eventb.texttools.diffmerge.EventBDiffProcessor;
import org.eventb.texttools.diffmerge.EventBEObjectMatcher;
import org.eventb.texttools.diffmerge.EventBMerger;
import org.eventb.texttools.prettyprint.PrettyPrinter;

public class PersistenceHelper {
    public static final Boolean DEBUG = false;

    public static IResource getIResource(Resource resource) {
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
        }
        return null;
    }

    public static void saveText(Resource resource, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        try {
            resource.save(Collections.EMPTY_MAP);
            long textTimestamp = PersistenceHelper.getTextTimestamp(resource);
            resource.setTimeStamp(textTimestamp);
            PersistenceHelper.getIResource(resource).setLocalTimeStamp(textTimestamp);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eventb.texttools", "Saving to RodinDB failed", (Throwable)e));
        }
    }

    public static void addTextAnnotation(Resource resource, String textRepresentation, long timeStamp) throws CoreException {
        EventBNamedCommentedComponentElement component = PersistenceHelper.getComponent(resource);
        if (component == null) {
            throw new CoreException((IStatus)new Status(4, "org.eventb.texttools", "Resource has no EventBComponent"));
        }
        PersistenceHelper.addTextAnnotation((EventBElement)component, textRepresentation, timeStamp);
    }

    public static void addTextAnnotation(EventBElement element, String textRepresentation, long timeStamp) {
        EMap attributes = element.getAttributes();
        Attribute textAttribute = (Attribute)attributes.get((Object)TextToolsPlugin.TYPE_TEXTREPRESENTATION.getId());
        if (textAttribute == null) {
            textAttribute = CoreFactory.eINSTANCE.createAttribute();
            textAttribute.setType(AttributeType.STRING);
            attributes.put((Object)TextToolsPlugin.TYPE_TEXTREPRESENTATION.getId(), (Object)textAttribute);
        }
        textAttribute.setValue((Object)textRepresentation);
        Attribute timeAttribute = (Attribute)attributes.get((Object)TextToolsPlugin.TYPE_LASTMODIFIED.getId());
        if (timeAttribute == null) {
            timeAttribute = CoreFactory.eINSTANCE.createAttribute();
            timeAttribute.setType(AttributeType.LONG);
            attributes.put((Object)TextToolsPlugin.TYPE_LASTMODIFIED.getId(), (Object)timeAttribute);
        }
        timeAttribute.setValue((Object)timeStamp);
    }

    public static void addUsesAnnotation(EventBElement element, String usesStatements) {
        EMap attributes = element.getAttributes();
        Attribute usesAttribute = (Attribute)attributes.get((Object)TextToolsPlugin.TYPE_USESEXTENSION.getId());
        if (usesAttribute == null) {
            usesAttribute = CoreFactory.eINSTANCE.createAttribute();
            usesAttribute.setType(AttributeType.STRING);
            attributes.put((Object)TextToolsPlugin.TYPE_USESEXTENSION.getId(), (Object)usesAttribute);
        }
        usesAttribute.setValue((Object)usesStatements);
    }

    private static void applyDiff(EventBNamedCommentedComponentElement root, IMerger evbMerger, Diff d) {
        try {
            if (d.getState() != DifferenceState.MERGED) {
                evbMerger.copyRightToLeft(d, null);
            }
        }
        catch (Exception exception) {
            System.out.println("SKIPPED:" + d);
        }
    }

    private static void mergeComponents(EventBNamedCommentedComponentElement oldVersion, EventBNamedCommentedComponentElement newVersion, IProgressMonitor monitor) {
        long time0 = System.currentTimeMillis();
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory());
        EventBEObjectMatcher matcher = new EventBEObjectMatcher();
        MatchEngineFactoryImpl matchEngineFactory = new MatchEngineFactoryImpl((IEObjectMatcher)matcher, (IComparisonFactory)comparisonFactory);
        matchEngineFactory.setRanking(20);
        MatchEngineFactoryRegistryImpl matchEngineRegistry = new MatchEngineFactoryRegistryImpl();
        matchEngineRegistry.add((IMatchEngine.Factory)matchEngineFactory);
        DefaultDiffEngine diffEngine = new DefaultDiffEngine((IDiffProcessor)new EventBDiffProcessor());
        EMFCompare comparator = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)matchEngineRegistry).setDiffEngine((IDiffEngine)diffEngine).build();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)oldVersion, (Notifier)newVersion, null);
        Comparison comparison = comparator.compare((IComparisonScope)scope);
        Object differences = comparison.getDifferences();
        long time1 = System.currentTimeMillis();
        IMerger.Registry registry = IMerger.RegistryImpl.createStandaloneInstance();
        EventBMerger evbMerger = new EventBMerger();
        evbMerger.setRanking(100);
        registry.add((IMerger)evbMerger);
        differences = PersistenceHelper.filter((List<Diff>)differences);
        Iterator iterator = differences.iterator();
        while (iterator.hasNext()) {
            Diff d = (Diff)iterator.next();
            PersistenceHelper.applyDiff(oldVersion, (IMerger)evbMerger, d);
        }
        long time2 = System.currentTimeMillis();
        if (DEBUG.booleanValue()) {
            System.out.println("new ModelMerge: " + (time1 - time0));
            System.out.println("merge.applyChanges: " + (time2 - time1));
        }
    }

    private static List<Diff> filter(List<Diff> differences) {
        ArrayList<Diff> newList = new ArrayList<Diff>();
        for (Diff d : differences) {
            if (d.getKind() == DifferenceKind.ADD && d.getMatch().getRight() == null) continue;
            newList.add(d);
        }
        return newList;
    }

    public static void mergeRootElement(Resource resource, EventBNamedCommentedComponentElement newVersion, IProgressMonitor monitor) {
        EventBNamedCommentedComponentElement component = PersistenceHelper.getComponent(resource);
        if (component != null) {
            long start = System.currentTimeMillis();
            PersistenceHelper.mergeComponents(component, newVersion, monitor);
            long end = System.currentTimeMillis();
            resource.setModified(true);
            resource.eSetDeliver(true);
            if (DEBUG.booleanValue()) {
                System.out.println("Time to merge components: " + (end - start));
            }
        } else {
            resource.getContents().add((Object)newVersion);
        }
    }

    public static String loadText(Resource resource, String linebreak) throws IOException {
        if (!resource.isLoaded()) {
            resource.load(Collections.EMPTY_MAP);
        }
        if (PersistenceHelper.isTextUptodate(resource)) {
            String text = PersistenceHelper.getTextAnnotation(resource);
            boolean namesMatch = true;
            EventBNamedCommentedComponentElement rootElement = PersistenceHelper.getComponent(resource);
            if (rootElement != null) {
                EventBParser parser = new EventBParser();
                try {
                    Start start = parser.parse(text, false);
                    PParseUnit pParseUnit = start.getPParseUnit();
                    String parsedName = null;
                    if (pParseUnit instanceof AMachineParseUnit) {
                        parsedName = ((AMachineParseUnit)start.getPParseUnit()).getName().getText();
                    }
                    if (pParseUnit instanceof AContextParseUnit) {
                        parsedName = ((AContextParseUnit)start.getPParseUnit()).getName().getText();
                    }
                    if (parsedName != null && !parsedName.equals(rootElement.getName())) {
                        namesMatch = false;
                        System.err.println("Conflicting names of ParseUnit! Expected name: '" + rootElement.getName() + "' actual name: '" + parsedName + "'! Prettyprinting unit...");
                    }
                }
                catch (BException e) {
                    e.printStackTrace();
                }
            }
            if (text != null && namesMatch) {
                return text;
            }
        }
        resource.unload();
        resource.load(Collections.EMPTY_MAP);
        EventBNamedCommentedComponentElement rootElement = PersistenceHelper.getComponent(resource);
        if (rootElement != null) {
            return PersistenceHelper.getPrettyPrint((EventBElement)rootElement, linebreak);
        }
        throw new IOException("Cannot find load Event-B component: No machine/context found");
    }

    public static String getTextAnnotation(Resource resource) {
        Attribute attr;
        EMap<String, Attribute> attributes = PersistenceHelper.getAttributesMap(resource);
        if (attributes != null && (attr = (Attribute)attributes.get((Object)TextToolsPlugin.TYPE_TEXTREPRESENTATION.getId())) != null) {
            return (String)attr.getValue();
        }
        return null;
    }

    public static EClass getComponentType(Resource resource) {
        EventBNamedCommentedComponentElement component = PersistenceHelper.getComponent(resource);
        if (component != null) {
            return component.eClass();
        }
        return null;
    }

    private static EventBNamedCommentedComponentElement getComponent(Resource resource) {
        EList contents = resource.getContents();
        if (contents.size() > 0 && contents.get(0) instanceof EventBNamedCommentedComponentElement) {
            return (EventBNamedCommentedComponentElement)contents.get(0);
        }
        return null;
    }

    private static long getTextTimestamp(Resource resource) {
        EMap<String, Attribute> attributes = PersistenceHelper.getAttributesMap(resource);
        if (attributes != null) {
            Attribute attr = (Attribute)attributes.get((Object)TextToolsPlugin.TYPE_LASTMODIFIED.getId());
            return attr != null ? (Long)attr.getValue() : -1L;
        }
        return -1L;
    }

    private static EMap<String, Attribute> getAttributesMap(Resource resource) {
        EObject object;
        EList contents = resource.getContents();
        if (contents.size() > 0 && (object = (EObject)contents.get(0)) instanceof EventBNamedCommentedComponentElement) {
            EventBNamedCommentedComponentElement component = (EventBNamedCommentedComponentElement)object;
            return component.getAttributes();
        }
        return null;
    }

    private static boolean isTextUptodate(Resource resource) {
        long resourceTimestamp;
        long textTimestamp;
        block4: {
            textTimestamp = PersistenceHelper.getTextTimestamp(resource);
            IResource file = PersistenceHelper.getIResource(resource);
            file.refreshLocal(1, null);
            resourceTimestamp = file.getLocalTimeStamp();
            if (textTimestamp < resourceTimestamp) break block4;
            return true;
        }
        try {
            long diff = resourceTimestamp - textTimestamp;
            if (diff < 50L) {
                return true;
            }
        }
        catch (CoreException e) {
            TextToolsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eventb.texttools", "Error checking file timestamps", (Throwable)e));
        }
        return false;
    }

    private static String getPrettyPrint(EventBElement rootElement, String linebreak) {
        StringBuilder buffer = new StringBuilder();
        new PrettyPrinter(buffer, linebreak, null).prettyPrint((EventBObject)rootElement);
        return buffer.toString();
    }
}

