/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.diffmerge;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eventb.emf.core.EventBObject;
import org.eventb.texttools.TextPositionUtil;

public class EventBMerger
extends AbstractMerger {
    private AttributeChangeMerger am = new AttributeChangeMerger();
    private ReferenceChangeMerger rm = new ReferenceChangeMerger();

    public boolean isMergerFor(Diff target) {
        if (target instanceof ReferenceChange) {
            ReferenceChange rtarget = (ReferenceChange)target;
            EReference reference = rtarget.getReference();
            if (reference.getName().equals("extends") || reference.getName().equals("refines") || reference.getName().equals("sees")) {
                return true;
            }
            if (reference.getName().contains("extension")) {
                System.out.println("REFERENCE:" + reference.getName());
                return false;
            }
            return true;
        }
        if (target instanceof AttributeChange) {
            return true;
        }
        System.out.println("TARGET:" + target);
        return false;
    }

    protected void accept(Diff diff, boolean rightToLeft) {
        throw new UnsupportedOperationException();
    }

    protected void reject(Diff diff, boolean rightToLeft) {
        assert (rightToLeft);
        EObject left = diff.getMatch().getLeft();
        EObject right = diff.getMatch().getRight();
        if (left == null) {
            super.reject(diff, rightToLeft);
            return;
        }
        if (left instanceof EventBObject) {
            TextPositionUtil.annotatePosition((EventBObject)left, TextPositionUtil.getTextRange((EventBObject)right));
        }
        if (this.rm.isMergerFor(diff)) {
            ReferenceChange d = (ReferenceChange)diff;
            this.rm.copyRightToLeft(diff, null);
            Object l = left.eGet((EStructuralFeature)d.getReference());
            Object r = right.eGet((EStructuralFeature)d.getReference());
            if (l instanceof EventBObject && r instanceof EventBObject) {
                TextPositionUtil.annotatePosition((EventBObject)l, TextPositionUtil.getTextRange((EventBObject)r));
            }
            return;
        }
        if (this.am.isMergerFor(diff)) {
            AttributeChange d = (AttributeChange)diff;
            this.am.copyRightToLeft(diff, null);
            Object l = left.eGet((EStructuralFeature)d.getAttribute());
            Object r = right.eGet((EStructuralFeature)d.getAttribute());
            if (l instanceof EventBObject && r instanceof EventBObject) {
                TextPositionUtil.annotatePosition((EventBObject)l, TextPositionUtil.getTextRange((EventBObject)r));
            }
            return;
        }
        System.out.println("DIFF:" + diff.getClass() + "  LEFT:" + left + "  -  RIGHT:" + right);
    }
}

