/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.internal.parsing;

import de.be4.eventb.core.parser.analysis.DepthFirstAdapter;
import de.be4.eventb.core.parser.node.AAction;
import de.be4.eventb.core.parser.node.AAnticipatedConvergence;
import de.be4.eventb.core.parser.node.AAxiom;
import de.be4.eventb.core.parser.node.ACarrierSet;
import de.be4.eventb.core.parser.node.AConstant;
import de.be4.eventb.core.parser.node.AContextParseUnit;
import de.be4.eventb.core.parser.node.AConvergentConvergence;
import de.be4.eventb.core.parser.node.ADerivedAxiom;
import de.be4.eventb.core.parser.node.ADerivedGuard;
import de.be4.eventb.core.parser.node.ADerivedInvariant;
import de.be4.eventb.core.parser.node.AEvent;
import de.be4.eventb.core.parser.node.AExtendedEventRefinement;
import de.be4.eventb.core.parser.node.AGuard;
import de.be4.eventb.core.parser.node.AInvariant;
import de.be4.eventb.core.parser.node.AMachineParseUnit;
import de.be4.eventb.core.parser.node.AOrdinaryConvergence;
import de.be4.eventb.core.parser.node.AParameter;
import de.be4.eventb.core.parser.node.ARefinesEventRefinement;
import de.be4.eventb.core.parser.node.AVariable;
import de.be4.eventb.core.parser.node.AVariant;
import de.be4.eventb.core.parser.node.AWitness;
import de.be4.eventb.core.parser.node.Node;
import de.be4.eventb.core.parser.node.PEventRefinement;
import de.be4.eventb.core.parser.node.Switch;
import de.be4.eventb.core.parser.node.TComment;
import de.be4.eventb.core.parser.node.TFormula;
import de.be4.eventb.core.parser.node.TIdentifierLiteral;
import de.be4.eventb.core.parser.node.TLabel;
import de.be4.eventb.core.parser.node.Token;
import de.hhu.stups.sablecc.patch.IToken;
import de.hhu.stups.sablecc.patch.PositionedNode;
import de.hhu.stups.sablecc.patch.SourcePosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eventb.emf.core.EventBCommented;
import org.eventb.emf.core.EventBElement;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.EventBNamedCommentedPredicateElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.Axiom;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.context.ContextFactory;
import org.eventb.emf.core.machine.Action;
import org.eventb.emf.core.machine.Convergence;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Guard;
import org.eventb.emf.core.machine.Invariant;
import org.eventb.emf.core.machine.Machine;
import org.eventb.emf.core.machine.MachineFactory;
import org.eventb.emf.core.machine.Variant;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.model.texttools.TextRange;
import org.eventb.texttools.model.texttools.TexttoolsFactory;

public class TransformationVisitor
extends DepthFirstAdapter {
    private IDocument document;
    private final Stack<EventBObject> stack = new Stack();
    private final Stack<Convergence> convergenceStack = new Stack();

    public <T extends EventBObject> T transform(Node rootNode, IDocument document) {
        this.document = document;
        this.stack.clear();
        this.convergenceStack.clear();
        rootNode.apply((Switch)this);
        this.document = null;
        assert (this.stack.size() == 1);
        return (T)this.stack.pop();
    }

    public void outAMachineParseUnit(AMachineParseUnit node) {
        Machine newNode = MachineFactory.eINSTANCE.createMachine();
        TextPositionUtil.annotatePosition((EventBObject)newNode, this.createTextRange((PositionedNode)node));
        this.handleNamedAndCommented((EventBNamed)newNode, (PositionedNode)node, (Token)node.getName(), node.getComments(), false);
        this.handleList((EventBObject)newNode, (EList<String>)newNode.getRefinesNames(), node.getRefinesNames());
        this.handleList((EventBObject)newNode, (EList<String>)newNode.getSeesNames(), node.getSeenNames());
        this.handleList(newNode.getEvents(), node.getEvents().size());
        if (node.getVariant() != null) {
            newNode.setVariant((Variant)this.stack.pop());
        }
        this.handleList(newNode.getInvariants(), node.getInvariants().size());
        this.handleList(newNode.getVariables(), node.getVariables().size());
        this.stack.push((EventBObject)newNode);
    }

    public void outAContextParseUnit(AContextParseUnit node) {
        Context newNode = ContextFactory.eINSTANCE.createContext();
        TextPositionUtil.annotatePosition((EventBObject)newNode, this.createTextRange((PositionedNode)node));
        this.handleNamedAndCommented((EventBNamed)newNode, (PositionedNode)node, (Token)node.getName(), node.getComments(), false);
        this.handleList((EventBObject)newNode, (EList<String>)newNode.getExtendsNames(), node.getExtendsNames());
        this.handleList(newNode.getAxioms(), node.getAxioms().size());
        this.handleList(newNode.getConstants(), node.getConstants().size());
        this.handleList(newNode.getSets(), node.getSets().size());
        this.stack.push((EventBObject)newNode);
    }

    public void outAEvent(AEvent node) {
        PEventRefinement refinement;
        Event newNode = MachineFactory.eINSTANCE.createEvent();
        TextPositionUtil.annotatePosition((EventBObject)newNode, this.createTextRange((PositionedNode)node));
        this.handleNamedAndCommented((EventBNamed)newNode, (PositionedNode)node, (Token)node.getName(), node.getComments(), false);
        if (node.getConvergence() != null) {
            newNode.setConvergence(this.convergenceStack.pop());
        }
        if ((refinement = node.getRefinement()) != null) {
            if (refinement instanceof ARefinesEventRefinement) {
                this.handleList((EventBObject)newNode, (EList<String>)newNode.getRefinesNames(), ((ARefinesEventRefinement)refinement).getNames());
                newNode.setExtended(false);
            } else {
                AExtendedEventRefinement extended = (AExtendedEventRefinement)refinement;
                TIdentifierLiteral extendsToken = extended.getName();
                String extendsName = extendsToken.getText();
                newNode.getRefinesNames().add((Object)extendsName);
                this.storePosition(extendsName, (EventBObject)newNode, (IToken)extendsToken);
                newNode.setExtended(true);
            }
        } else {
            newNode.setExtended(false);
        }
        this.handleList(newNode.getActions(), node.getActions().size());
        this.handleList(newNode.getWitnesses(), node.getWitnesses().size());
        this.handleList(newNode.getGuards(), node.getGuards().size());
        this.handleList(newNode.getParameters(), node.getParameters().size());
        this.stack.push((EventBObject)newNode);
    }

    public void outAVariable(AVariable node) {
        this.handleNamedAndCommented((EventBNamed)MachineFactory.eINSTANCE.createVariable(), (PositionedNode)node, (Token)node.getName(), node.getComments(), true);
    }

    public void outAInvariant(AInvariant node) {
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)MachineFactory.eINSTANCE.createInvariant(), (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outADerivedInvariant(ADerivedInvariant node) {
        Invariant invariant = MachineFactory.eINSTANCE.createInvariant();
        invariant.setTheorem(true);
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)invariant, (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outAVariant(AVariant node) {
        Variant newNode = MachineFactory.eINSTANCE.createVariant();
        TextPositionUtil.annotatePosition((EventBObject)newNode, this.createTextRange((PositionedNode)node));
        this.handleComment((EventBCommented)newNode, node.getComments());
        TFormula exprToken = node.getExpression();
        String exprString = exprToken.getText();
        newNode.setExpression(exprString);
        this.storePosition(exprString, (EventBObject)newNode, (IToken)exprToken);
        this.stack.push((EventBObject)newNode);
    }

    public void outAOrdinaryConvergence(AOrdinaryConvergence node) {
        this.convergenceStack.push(Convergence.ORDINARY);
    }

    public void outAAnticipatedConvergence(AAnticipatedConvergence node) {
        this.convergenceStack.push(Convergence.ANTICIPATED);
    }

    public void outAConvergentConvergence(AConvergentConvergence node) {
        this.convergenceStack.push(Convergence.CONVERGENT);
    }

    public void outAAction(AAction node) {
        Action newNode = MachineFactory.eINSTANCE.createAction();
        this.handleNamedAndCommented((EventBNamed)newNode, (PositionedNode)node, (Token)node.getName(), node.getComments(), true);
        TFormula actionToken = node.getAction();
        String actionString = actionToken.getText();
        newNode.setAction(actionString);
        this.storePosition(actionString, (EventBObject)newNode, (IToken)actionToken);
    }

    public void outAWitness(AWitness node) {
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)MachineFactory.eINSTANCE.createWitness(), (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outAGuard(AGuard node) {
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)MachineFactory.eINSTANCE.createGuard(), (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outADerivedGuard(ADerivedGuard node) {
        Guard guard = MachineFactory.eINSTANCE.createGuard();
        guard.setTheorem(true);
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)guard, (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outAParameter(AParameter node) {
        this.handleNamedAndCommented((EventBNamed)MachineFactory.eINSTANCE.createParameter(), (PositionedNode)node, (Token)node.getName(), node.getComments(), true);
    }

    public void outAAxiom(AAxiom node) {
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)ContextFactory.eINSTANCE.createAxiom(), (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outADerivedAxiom(ADerivedAxiom node) {
        Axiom axiom = ContextFactory.eINSTANCE.createAxiom();
        axiom.setTheorem(true);
        this.handleLabeledPredicate((EventBNamedCommentedPredicateElement)axiom, (Node)node, node.getPredicate(), node.getName(), node.getComments(), true);
    }

    public void outACarrierSet(ACarrierSet node) {
        this.handleNamedAndCommented((EventBNamed)ContextFactory.eINSTANCE.createCarrierSet(), (PositionedNode)node, (Token)node.getName(), node.getComments(), true);
    }

    public void outAConstant(AConstant node) {
        this.handleNamedAndCommented((EventBNamed)ContextFactory.eINSTANCE.createConstant(), (PositionedNode)node, (Token)node.getName(), node.getComments(), true);
    }

    private void handleNamedAndCommented(EventBNamed newNode, PositionedNode node, Token name, LinkedList<TComment> comments, boolean store) {
        if (store) {
            TextPositionUtil.annotatePosition((EventBObject)((EventBElement)newNode), this.createTextRange(node));
        }
        this.handleComment((EventBCommented)newNode, comments);
        this.handleName(newNode, name);
        if (store) {
            this.stack.push((EventBObject)((EventBElement)newNode));
        }
    }

    private void handleLabeledPredicate(EventBNamedCommentedPredicateElement newNode, Node node, TFormula predicate, TLabel name, LinkedList<TComment> comments, boolean store) {
        this.handleNamedAndCommented((EventBNamed)newNode, (PositionedNode)node, (Token)name, comments, store);
        String predText = predicate.getText();
        newNode.setPredicate(predText);
        this.storePosition(predText, (EventBObject)newNode, (IToken)predicate);
    }

    private <T extends EventBObject> void handleList(EList<T> targetList, int childrenNumber) {
        int i = 0;
        while (i < childrenNumber) {
            EventBObject childNode = this.stack.pop();
            targetList.add(0, (Object)childNode);
            ++i;
        }
    }

    private <T> void handleList(EventBObject emfParent, EList<String> targetList, List<TIdentifierLiteral> children) {
        for (TIdentifierLiteral token : children) {
            String text = token.getText();
            targetList.add((Object)text);
            this.storePosition(text, emfParent, (IToken)token);
        }
    }

    private void handleName(EventBNamed emfElement, Token nameToken) {
        if (nameToken != null) {
            String name = nameToken.getText();
            emfElement.setName(name);
            this.storePosition(name, (EventBObject)((EventBElement)emfElement), (IToken)nameToken);
        }
    }

    private void handleComment(EventBCommented emfElement, LinkedList<TComment> comments) {
        if (comments != null && comments.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = comments.iterator();
            while (iterator.hasNext()) {
                TComment comment = (TComment)iterator.next();
                buffer.append(comment.getText());
                if (!iterator.hasNext()) continue;
                buffer.append('\n');
            }
            String completeComment = buffer.toString();
            emfElement.setComment(completeComment);
            TComment firstToken = comments.get(0);
            TextRange range = this.createTextRange(this.calculateOffset(firstToken.getLine(), firstToken.getPos()), buffer.length());
            this.storePosition(completeComment, (EventBObject)((EventBElement)emfElement), range);
        }
    }

    private void storePosition(String keyString, EventBObject emfParent, TextRange range) {
        if (keyString == null) {
            return;
        }
        if (range != null) {
            TextPositionUtil.addInternalPosition(emfParent, keyString, range);
        }
    }

    private void storePosition(String keyString, EventBObject emfParent, IToken token) {
        this.storePosition(keyString, emfParent, this.createTextRange(token));
    }

    private TextRange createTextRange(IToken token) {
        int offset = this.calculateOffset(token.getLine(), token.getPos());
        int length = token.getText().length();
        return this.createTextRange(offset, length);
    }

    private TextRange createTextRange(PositionedNode node) {
        int offset = this.calculateOffset(node.getStartPos());
        int length = this.calculateOffset(node.getEndPos()) - offset;
        return this.createTextRange(offset, length);
    }

    private TextRange createTextRange(int offset, int length) {
        TextRange range = TexttoolsFactory.eINSTANCE.createTextRange();
        range.setOffset(offset);
        range.setLength(length);
        return range;
    }

    private int calculateOffset(int line, int pos) {
        try {
            return this.document.getLineOffset(line - 1) + pos - 1;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private int calculateOffset(SourcePosition position) {
        if (position != null) {
            return this.calculateOffset(position.getLine(), position.getPos());
        }
        return 0;
    }
}

