/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools.formulas;

import java.util.List;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.SourceLocation;
import org.eventb.emf.core.EventBElement;

public class FormulaParseException
extends Exception {
    private final EventBElement emfExpression;
    private final List<ASTProblem> astProblems;
    private final String formula;

    public FormulaParseException(EventBElement emfExpr, String formula, List<ASTProblem> problems) {
        this.emfExpression = emfExpr;
        this.formula = formula;
        this.astProblems = problems;
    }

    public EventBElement getEmfObject() {
        return this.emfExpression;
    }

    public List<ASTProblem> getAstProblems() {
        return this.astProblems;
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public String getLocalizedMessage() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Parse problems in formula '");
        buffer.append(this.getFormula());
        buffer.append("': [");
        List<ASTProblem> problems = this.getAstProblems();
        int i = 0;
        while (i < problems.size()) {
            ASTProblem problem = problems.get(i);
            buffer.append(" (");
            SourceLocation location = problem.getSourceLocation();
            buffer.append(String.valueOf(location.getStart()) + "-" + location.getEnd());
            buffer.append(") ");
            buffer.append(String.format(problem.getMessage().toString(), problem.getArgs()));
            ++i;
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

