/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texttools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eventb.emf.core.Annotation;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.impl.CoreFactoryImpl;
import org.eventb.texttools.model.texttools.TextRange;
import org.eventb.texttools.model.texttools.TexttoolsFactory;

public class TextPositionUtil {
    public static final String ANNOTATION_TEXTRANGE = "http://emf.eventb.org/models/core/texttools/TextRange";

    public static TextRange getTextRange(EventBObject element) {
        Annotation annotation;
        if (element != null && (annotation = element.getAnnotation(ANNOTATION_TEXTRANGE)) != null) {
            EList contents = annotation.getContents();
            for (EObject object : contents) {
                if (!(object instanceof TextRange)) continue;
                return (TextRange)object;
            }
        }
        return null;
    }

    public static void annotatePosition(EventBObject element, TextRange range) {
        if (range != null) {
            Annotation annotation = CoreFactoryImpl.eINSTANCE.createAnnotation();
            annotation.setEventBObject(element);
            annotation.setSource(ANNOTATION_TEXTRANGE);
            annotation.getContents().add((Object)range);
            element.getAnnotations().add((Object)annotation);
        }
    }

    public static void annotatePosition(EventBObject element, int startPos, int length) {
        TextRange range = TexttoolsFactory.eINSTANCE.createTextRange();
        range.setOffset(startPos);
        range.setLength(length);
        TextPositionUtil.annotatePosition(element, range);
    }

    public static void addInternalPosition(EventBObject emfElement, String key, TextRange range) {
        Assert.isNotNull((Object)emfElement);
        Assert.isNotNull((Object)range);
        Assert.isNotNull((Object)key);
        TextRange parentRange = TextPositionUtil.getTextRange(emfElement);
        if (parentRange != null) {
            TextPositionUtil.getSubRangeMap(parentRange).put(key, range);
        }
    }

    public static void replaceInternalPosition(EventBObject emfElement, String oldKey, String newKey, TextRange newRange) {
        Assert.isNotNull((Object)emfElement);
        Assert.isNotNull((Object)oldKey);
        TextRange parentRange = TextPositionUtil.getTextRange(emfElement);
        if (parentRange != null) {
            Map<String, TextRange> subRangeMap = TextPositionUtil.getSubRangeMap(parentRange);
            subRangeMap.remove(oldKey);
            if (newKey != null && newRange != null) {
                subRangeMap.put(newKey, newRange);
            }
        }
    }

    public static TextRange getInternalPosition(EventBObject emfElement, String key) {
        Assert.isNotNull((Object)emfElement);
        Assert.isNotNull((Object)key);
        TextRange parentRange = TextPositionUtil.getTextRange(emfElement);
        if (parentRange != null) {
            return TextPositionUtil.getSubRangeMap(parentRange).get(key);
        }
        return null;
    }

    private static Map<String, TextRange> getSubRangeMap(TextRange parentRange) {
        Map<String, TextRange> result = parentRange.getSubTextRanges();
        if (result == null) {
            result = new HashMap<String, TextRange>();
            parentRange.setSubTextRanges(result);
        }
        return result;
    }

    public static TextRange createTextRange(EventBObject element) {
        TextRange origRange = TextPositionUtil.getTextRange(element);
        if (origRange != null) {
            TextRange result = TexttoolsFactory.eINSTANCE.createTextRange();
            result.setLength(origRange.getLength());
            result.setOffset(origRange.getOffset());
            return result;
        }
        return null;
    }

    public static void correctStartOffset(TextRange range, int length) {
        if (range != null) {
            range.setOffset(range.getOffset() + length + 1);
            range.setLength(range.getLength() - length - 1);
        }
    }
}

