/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.outline;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.editors.text.TextEditor;
import org.eventb.emf.core.EventBObject;
import org.eventb.texteditor.ui.outline.ContextNavigationProvider;
import org.eventb.texteditor.ui.outline.INavigationProvider;
import org.eventb.texteditor.ui.outline.MachineNavigationProvider;
import org.eventb.texttools.model.texttools.TextRange;

public class RevealSelectionListener
implements ISelectionChangedListener {
    private final INavigationProvider machineNavProvider = new MachineNavigationProvider();
    private final INavigationProvider contextNavProvider = new ContextNavigationProvider();
    private final TextEditor editor;

    public RevealSelectionListener(TextEditor editor) {
        this.editor = editor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() != 1) {
            return;
        }
        Object firstElement = structuredSelection.getFirstElement();
        if (!(firstElement instanceof EventBObject)) {
            return;
        }
        this.highlightElement((EventBObject)firstElement);
    }

    private void highlightElement(EventBObject element) {
        TextRange range = null;
        String packageNsURI = element.eClass().getEPackage().getNsURI();
        if (packageNsURI.equals("http://emf.eventb.org/models/core/machine/2014")) {
            range = this.machineNavProvider.getHighlightRange(element);
        } else if (packageNsURI.equals("http://emf.eventb.org/models/core/context/2014")) {
            range = this.contextNavProvider.getHighlightRange(element);
        }
        if (range != null) {
            this.editor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }
}

