/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Machine;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.build.dom.IParseResultListener;

public class ContentProvider
implements ITreeContentProvider,
IParseResultListener {
    private final DomManager domManager = TextEditorPlugin.getDomManager();
    private static final Object[] NO_ELEMENTS = new Object[0];
    private Object[] machineChildren;
    private Object[] contextChildren;
    private final Map<Event, Object[]> eventChildren = new HashMap<Event, Object[]>();
    private TreeViewer viewer;
    private Object currentInput;

    public synchronized Object[] getElements(Object inputElement) {
        if (inputElement instanceof IEditorInput) {
            DomManager.ParseResult lastParseResult = this.domManager.getLastParseResult((IEditorInput)inputElement);
            if (lastParseResult != null) {
                return new Object[]{lastParseResult.astRoot};
            }
            if (inputElement instanceof IFileEditorInput) {
                IFile inputFile = ((IFileEditorInput)inputElement).getFile();
                return this.createFallbackStructure(inputFile);
            }
        }
        return NO_ELEMENTS;
    }

    public synchronized Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Machine) {
            return this.internalGetChildren((Machine)parentElement);
        }
        if (parentElement instanceof Context) {
            return this.internalGetChildren((Context)parentElement);
        }
        if (parentElement instanceof Event) {
            return this.internalGetChildren((Event)parentElement);
        }
        return NO_ELEMENTS;
    }

    public synchronized Object getParent(Object element) {
        if (element instanceof EventBObject) {
            EventBObject emfObject = (EventBObject)element;
            return emfObject.eContainer();
        }
        return null;
    }

    public synchronized boolean hasChildren(Object element) {
        int count = 0;
        if (element instanceof Machine) {
            count = this.internalGetChildren((Machine)element).length;
        }
        if (element instanceof Context) {
            count = this.internalGetChildren((Context)element).length;
        }
        if (element instanceof Event) {
            count = this.internalGetChildren((Event)element).length;
        }
        return count > 0;
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.registerLister(newInput);
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        }
        this.clearCache();
        this.currentInput = newInput;
    }

    public synchronized void dispose() {
        this.registerLister(null);
        this.viewer = null;
        this.clearCache();
    }

    private void clearCache() {
        this.machineChildren = null;
        this.contextChildren = null;
        this.eventChildren.clear();
    }

    private void registerLister(Object newInput) {
        if (this.currentInput != null && this.currentInput instanceof IEditorInput) {
            this.domManager.removeParseResultListener((IEditorInput)this.currentInput, this);
        }
        if (newInput != null && newInput instanceof IEditorInput) {
            this.domManager.addParseResultListener((IEditorInput)newInput, this);
        }
    }

    private Object[] createFallbackStructure(IFile inputFile) {
        return NO_ELEMENTS;
    }

    private Object[] internalGetChildren(Machine machine) {
        if (this.machineChildren == null) {
            ArrayList children = new ArrayList();
            children.addAll(machine.getVariables());
            children.addAll(machine.getInvariants());
            children.addAll(machine.getVariants());
            children.addAll(machine.getEvents());
            this.machineChildren = children.toArray();
        }
        return this.machineChildren;
    }

    private Object[] internalGetChildren(Context context) {
        if (this.contextChildren == null) {
            ArrayList children = new ArrayList();
            children.addAll(context.getConstants());
            children.addAll(context.getAxioms());
            children.addAll(context.getSets());
            this.contextChildren = children.toArray();
        }
        return this.contextChildren;
    }

    private Object[] internalGetChildren(Event event) {
        if (!this.eventChildren.containsKey(event)) {
            ArrayList children = new ArrayList();
            children.addAll(event.getWitnesses());
            children.addAll(event.getGuards());
            children.addAll(event.getActions());
            this.eventChildren.put(event, children.toArray());
        }
        return this.eventChildren.get(event);
    }

    private void refresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
            this.viewer.expandAll();
        }
    }

    @Override
    public void parseResultChanged(DomManager.ParseResult parseResult) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.clearCache();
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ContentProvider.this.refresh();
                }
            });
        }
    }
}

