/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Machine;
import org.eventb.emf.core.machine.Parameter;
import org.eventb.emf.core.machine.Variable;
import org.eventb.emf.core.machine.util.MachineSwitch;
import org.eventb.texteditor.ui.build.dom.AbstractDom;
import org.eventb.texteditor.ui.build.dom.ContextDom;
import org.eventb.texteditor.ui.build.dom.DomBuilder;
import org.eventb.texteditor.ui.build.dom.EventDom;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDom;
import org.eventb.texteditor.ui.build.dom.MachineDom;

public class MachineCollectingSwitch
extends MachineSwitch<Boolean> {
    private final MachineDom machineDom;
    private IDom currentParent = null;
    private final Resource machineResource;

    protected MachineCollectingSwitch(MachineDom dom, Resource machineResource) {
        this.machineDom = dom;
        this.machineResource = machineResource;
    }

    protected AbstractDom getDom() {
        return this.machineDom;
    }

    public IDom getCurrentParentDom() {
        return this.currentParent;
    }

    public Boolean caseEventBObject(EventBObject object) {
        return true;
    }

    public Boolean caseMachine(Machine object) {
        this.machineDom.setMachine(object);
        EList refines = object.getRefines();
        for (Machine machine : refines) {
            IComponentDom dom = DomBuilder.getReferencedDom((EventBNamedCommentedComponentElement)machine, this.machineResource);
            if (dom == null) continue;
            Assert.isTrue((boolean)(dom instanceof MachineDom));
            this.machineDom.addRefinedMachine((MachineDom)dom);
        }
        EList sees = object.getSees();
        for (Context context : sees) {
            IComponentDom dom = DomBuilder.getReferencedDom((EventBNamedCommentedComponentElement)context, this.machineResource);
            if (dom == null) continue;
            Assert.isTrue((boolean)(dom instanceof ContextDom));
            this.machineDom.addSeenContext((ContextDom)dom);
        }
        this.currentParent = this.machineDom;
        return true;
    }

    public Boolean caseVariable(Variable object) {
        this.machineDom.addVariable(object);
        return false;
    }

    public Boolean caseEvent(Event object) {
        EventDom eventDom = new EventDom(object, this.machineDom);
        eventDom.addAllRefinedEvent((List<Event>)object.getRefines());
        eventDom.addAllParameters((List<Parameter>)object.getParameters());
        this.machineDom.addChild(eventDom);
        this.currentParent = eventDom;
        return true;
    }
}

