/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eventb.texteditor.ui.editor.EventBTextEditor;

public class ModelChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final EventBTextEditor editor;

    public ModelChangeListener(EventBTextEditor editor) {
        this.editor = editor;
    }

    public void resourceChanged(IResourceChangeEvent e) {
        IResourceDelta delta = e.getDelta();
        try {
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta == null) {
            return false;
        }
        IFile file = this.getFile();
        if (file == null) {
            return false;
        }
        if ((delta = delta.findMember(file.getFullPath())) == null) {
            return false;
        }
        if (delta.getKind() == 4 && (0x100 & delta.getFlags()) != 0 && this.editor.isDirty()) {
            this.editor.changeWhileDirty();
        }
        return false;
    }

    protected long computeModificationStamp(IResource resource) {
        long modificationStamp = resource.getModificationStamp();
        IPath path = resource.getLocation();
        if (path == null) {
            return modificationStamp;
        }
        modificationStamp = path.toFile().lastModified();
        return modificationStamp;
    }

    private IFile getFile() {
        IEditorInput editorInput = this.editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }
}

