/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorInput;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.machine.Machine;
import org.eventb.texteditor.ui.build.dom.AbstractComponentDom;
import org.eventb.texteditor.ui.build.dom.ContextDom;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDomChangeListener;
import org.eventb.texteditor.ui.build.dom.IParseResultListener;
import org.eventb.texteditor.ui.build.dom.MachineDom;

public class DomManager {
    private final Map<Resource, IComponentDom> lastDom = new HashMap<Resource, IComponentDom>();
    private final Map<IEditorInput, ParseResult> lastParseResults = new HashMap<IEditorInput, ParseResult>();
    private final Set<IDomChangeListener> domListeners = new HashSet<IDomChangeListener>();
    private final Map<IEditorInput, List<IParseResultListener>> parseResultListeners = new HashMap<IEditorInput, List<IParseResultListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDom(IComponentDom dom) {
        if (dom != null) {
            Map<Resource, IComponentDom> map = this.lastDom;
            synchronized (map) {
                this.lastDom.put(dom.getResource(), dom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDom(Resource resource) {
        Map<Resource, IComponentDom> map = this.lastDom;
        synchronized (map) {
            this.lastDom.remove(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentDom getDom(Resource resource) {
        Map<Resource, IComponentDom> map = this.lastDom;
        synchronized (map) {
            return this.lastDom.get(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentDom getDom(Resource resource, EventBNamedCommentedComponentElement component) {
        Map<Resource, IComponentDom> map = this.lastDom;
        synchronized (map) {
            IComponentDom dom = this.lastDom.get(resource);
            if (dom == null && component != null) {
                dom = this.createNewDom(resource, component);
                this.storeDom(dom);
            }
            return dom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentDom getDom(EventBNamedCommentedComponentElement component) {
        Resource resource = component.eResource();
        if (resource != null) {
            Map<Resource, IComponentDom> map = this.lastDom;
            synchronized (map) {
                return this.getDom(resource, component);
            }
        }
        return null;
    }

    private IComponentDom createNewDom(Resource resource, EventBNamedCommentedComponentElement component) {
        AbstractComponentDom dom = component instanceof Machine ? new MachineDom(resource, (Machine)component) : new ContextDom(resource, (Context)component);
        return dom;
    }

    public void storeParseResult(IEditorInput editorInput, String textInput, EventBNamedCommentedComponentElement astRoot) {
        ParseResult parseResult = new ParseResult((EventBObject)astRoot, textInput);
        this.lastParseResults.put(editorInput, parseResult);
        this.notifyParseResultListeners(editorInput, parseResult);
    }

    public ParseResult getLastParseResult(IEditorInput editorInput) {
        return this.lastParseResults.get(editorInput);
    }

    public void addParseResultListener(IEditorInput editorInput, IParseResultListener listener) {
        if (!this.parseResultListeners.containsKey(editorInput)) {
            ArrayList<IParseResultListener> list = new ArrayList<IParseResultListener>();
            list.add(listener);
            this.parseResultListeners.put(editorInput, list);
        } else {
            this.parseResultListeners.get(editorInput).add(listener);
        }
    }

    public void removeParseResultListener(IEditorInput editorInput, IParseResultListener listener) {
        if (this.parseResultListeners.containsKey(editorInput)) {
            List<IParseResultListener> list = this.parseResultListeners.get(editorInput);
            list.remove(listener);
            if (list.isEmpty()) {
                this.parseResultListeners.remove(editorInput);
            }
        }
    }

    private void notifyParseResultListeners(IEditorInput editorInput, ParseResult parseResult) {
        if (this.parseResultListeners.containsKey(editorInput)) {
            for (IParseResultListener listener : this.parseResultListeners.get(editorInput)) {
                listener.parseResultChanged(parseResult);
            }
        }
    }

    public void addDomChangeListener(IDomChangeListener listener) {
        if (listener != null && !this.domListeners.contains(listener)) {
            this.domListeners.add(listener);
        }
    }

    public void removeDomChangeListener(IDomChangeListener listener) {
        if (listener != null) {
            this.domListeners.remove(listener);
        }
    }

    public void notifyDomChangeListeners(IComponentDom dom) {
        for (IDomChangeListener listener : this.domListeners) {
            listener.domChanged(dom);
        }
    }

    public class ParseResult {
        public final EventBObject astRoot;
        public final String textInput;

        public ParseResult(EventBObject astRoot, String textInput) {
            this.astRoot = astRoot;
            this.textInput = textInput;
        }
    }
}

