/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eventb.emf.core.EventBElement;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.EventBNamedCommentedExpressionElement;
import org.eventb.emf.core.EventBNamedCommentedPredicateElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.Context;
import org.eventb.emf.core.machine.Action;
import org.eventb.emf.core.machine.Machine;
import org.eventb.texteditor.ui.build.ast.ContextTranslateSwitch;
import org.eventb.texteditor.ui.build.ast.MachineTranslateSwitch;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.model.texttools.TextRange;
import org.rodinp.keyboard.core.RodinKeyboardCore;

public class FormulaTranslator {
    private IDocument document;
    private EventBTextEditor editor;

    public void translateFormulas(EventBNamedCommentedComponentElement astRoot, IDocument document, EventBTextEditor editor) {
        block3: {
            TreeIterator iterator;
            block2: {
                this.document = document;
                this.editor = editor;
                iterator = EcoreUtil.getAllContents((EObject)astRoot, (boolean)false);
                if (!(astRoot instanceof Machine)) break block2;
                MachineTranslateSwitch switcher = new MachineTranslateSwitch(this);
                while (iterator.hasNext()) {
                    switcher.doSwitch((EObject)iterator.next());
                }
                break block3;
            }
            if (!(astRoot instanceof Context)) break block3;
            ContextTranslateSwitch switcher = new ContextTranslateSwitch(this);
            while (iterator.hasNext()) {
                switcher.doSwitch((EObject)iterator.next());
            }
        }
    }

    public void replace(EventBNamedCommentedPredicateElement predicate) {
        String translatedInput;
        String input = predicate.getPredicate();
        if (input != null && !input.equals(translatedInput = RodinKeyboardCore.translate((String)input))) {
            predicate.setPredicate(translatedInput);
            TextRange range = this.updatePosition((EventBElement)predicate, input, translatedInput);
            this.updateDocument(input, translatedInput, range);
        }
    }

    public void replace(EventBNamedCommentedExpressionElement expression) {
        String translatedInput;
        String input = expression.getExpression();
        if (input != null && !input.equals(translatedInput = RodinKeyboardCore.translate((String)input))) {
            expression.setExpression(translatedInput);
            TextRange range = this.updatePosition((EventBElement)expression, input, translatedInput);
            this.updateDocument(input, translatedInput, range);
        }
    }

    public void replace(Action action) {
        String translatedInput;
        String input = action.getAction();
        if (input != null && !input.equals(translatedInput = RodinKeyboardCore.translate((String)input))) {
            action.setAction(translatedInput);
            TextRange range = this.updatePosition((EventBElement)action, input, translatedInput);
            this.updateDocument(input, translatedInput, range);
        }
    }

    private void updateDocument(String input, String translatedInput, final TextRange range) {
        final int lengthDiff = input.length() - translatedInput.length();
        Assert.isTrue((lengthDiff >= 0 ? 1 : 0) != 0, (String)"Expecting length of translated formula to be less or equal to original length");
        final String filledString = this.fillOutput(translatedInput, lengthDiff);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int cursorOffset = -1;
                    if (FormulaTranslator.this.editor != null) {
                        cursorOffset = FormulaTranslator.this.editor.getCursorOffset();
                    }
                    int startOffset = range.getOffset();
                    FormulaTranslator.this.document.replace(startOffset, filledString.length(), filledString);
                    if (FormulaTranslator.this.editor != null && cursorOffset >= 0) {
                        FormulaTranslator.this.correctCursorPosition(cursorOffset, range, lengthDiff);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        });
    }

    private void correctCursorPosition(int oldOffset, TextRange range, int lengthCorrection) {
        if (oldOffset >= range.getOffset() && oldOffset <= range.getOffset() + range.getLength() + lengthCorrection) {
            this.editor.setCurserOffset(oldOffset - lengthCorrection);
        }
    }

    private String fillOutput(String output, int count) {
        if (count > 0) {
            StringBuilder buffer = new StringBuilder(output);
            int i = 0;
            while (i < count) {
                buffer.append(' ');
                ++i;
            }
            return buffer.toString();
        }
        return output;
    }

    private TextRange updatePosition(EventBElement parent, String oldContent, String newContent) {
        TextRange range = TextPositionUtil.getInternalPosition((EventBObject)parent, (String)oldContent);
        range.setLength(newContent.length());
        TextPositionUtil.replaceInternalPosition((EventBObject)parent, (String)oldContent, (String)newContent, (TextRange)range);
        return range;
    }
}

