/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.reconciler;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eventb.texteditor.ui.TextDecoration;
import org.eventb.texteditor.ui.build.dom.IDom;
import org.eventb.texteditor.ui.reconciler.IdentifierDetector;

public class IdentifierRule
implements IRule {
    private final IWordDetector fDetector = new IdentifierDetector();
    private final IToken fDefaultToken = new Token(null);
    private final StringBuffer fBuffer = new StringBuffer();
    private int offset;
    private IDom dom;

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.dom != null) {
            this.readIdentifier(scanner);
            if (this.fBuffer.length() > 0) {
                IToken token;
                String buffer = this.fBuffer.toString();
                IDom.IdentifierType type = null;
                IDom scope = this.dom.getScopingDom(this.offset);
                if (scope != null) {
                    type = scope.getIdentifierType(buffer);
                }
                if ((token = this.getToken(type)) != null) {
                    return token;
                }
                if (this.fDefaultToken.isUndefined()) {
                    this.unreadBuffer(scanner);
                }
                return this.fDefaultToken;
            }
        }
        return Token.UNDEFINED;
    }

    private void readIdentifier(ICharacterScanner scanner) {
        this.fBuffer.setLength(0);
        if (this.newIdentifierBegins(scanner)) {
            int c = scanner.read();
            if (c != -1 && this.fDetector.isWordStart((char)c)) {
                do {
                    this.fBuffer.append((char)c);
                } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
                scanner.unread();
            } else {
                scanner.unread();
            }
        }
    }

    private boolean newIdentifierBegins(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        return !this.fDetector.isWordStart((char)c) && !this.fDetector.isWordPart((char)c);
    }

    private IToken getToken(IDom.IdentifierType type) {
        if (type != null) {
            switch (type) {
                case GlobalVariable: {
                    return TextDecoration.ESyntaxElement.GlobalVariable.getToken();
                }
                case LocalVariable: {
                    return TextDecoration.ESyntaxElement.BoundedVariable.getToken();
                }
                case Parameter: {
                    return TextDecoration.ESyntaxElement.Parameter.getToken();
                }
                case Constant: {
                    return TextDecoration.ESyntaxElement.Constant.getToken();
                }
                case Set: {
                    return TextDecoration.ESyntaxElement.Set.getToken();
                }
            }
        }
        return null;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setDom(IDom dom) {
        this.dom = dom;
    }
}

