/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor.codecompletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eventb.texteditor.ui.Images;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDom;
import org.eventb.texteditor.ui.build.dom.MachineDom;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texteditor.ui.editor.codecompletion.EventBCompletionProposal;
import org.eventb.texteditor.ui.editor.codecompletion.EventBTemplateProposal;
import org.eventb.texteditor.ui.editor.codecompletion.IRelevantProposal;
import org.eventb.texttools.Constants;

public class DefaultContentAssist
extends TemplateCompletionProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final String PREFIX = "org.eventb.texteditor.";
    private ContributionTemplateStore templateStore;
    private final DomManager domManager = TextEditorPlugin.getDomManager();
    private final EventBTextEditor editor;
    private String errorMessage;
    private String contentType;
    private Region region;
    private String prefix;
    private IComponentDom dom;
    private IDom scopingDom;
    private IDom.Type componentType;
    private IDocument document;
    private ITextViewer viewer;
    private boolean offsetInEvents;

    public DefaultContentAssist(EventBTextEditor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.errorMessage = null;
        try {
            this.setupContextInfo(viewer, offset);
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            this.computeIdentifierProposals(proposals);
            this.computeKeywordProposals(proposals);
            this.computeTemplateProposals(proposals);
            return this.sort(proposals);
        }
        catch (BadLocationException badLocationException) {
            this.errorMessage = "Error while calculating content type";
            return NO_PROPOSALS;
        }
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new EventBTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    private void setupContextInfo(ITextViewer viewer, int offset) throws BadLocationException {
        this.viewer = viewer;
        offset = this.adjustOffset(viewer, offset);
        this.document = viewer.getDocument();
        this.contentType = this.document.getContentType(offset);
        this.prefix = this.extractPrefix(viewer, offset);
        this.region = new Region(offset - this.prefix.length(), this.prefix.length());
        int eventsOffset = this.document.get().indexOf("events");
        this.offsetInEvents = offset >= eventsOffset;
        this.dom = this.domManager.getDom(this.editor.getResource());
        if (this.dom != null) {
            this.scopingDom = this.dom.getScopingDom(offset);
            this.componentType = this.dom instanceof MachineDom ? IDom.Type.Machine : IDom.Type.Context;
        }
    }

    private ICompletionProposal[] sort(List<ICompletionProposal> proposals) {
        Collections.sort(proposals, new ProposalComparator());
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void computeTemplateProposals(List<ICompletionProposal> proposals) {
        Template[] templates = this.getTemplates();
        TemplateContext context = this.createContext(this.viewer, (IRegion)this.region);
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().startsWith(this.prefix)) {
                EventBTemplateProposal proposal = new EventBTemplateProposal(template, context, (IRegion)this.region, this.getImage(template), this.getRelevance(template, this.prefix));
                proposals.add(proposal);
            }
            ++n2;
        }
    }

    private void computeKeywordProposals(List<ICompletionProposal> proposals) {
        if (!"__dftl_partition_content_type".equals(this.contentType)) {
            return;
        }
        HashMap<String, ICompletionProposal> result = new HashMap<String, ICompletionProposal>();
        int componentRelevance = 50;
        int scopeRelevance = 30;
        this.addKeywords(result, Arrays.asList(Constants.formula_keywords), componentRelevance, scopeRelevance);
        componentRelevance = this.componentType == IDom.Type.Machine ? 50 : 0;
        scopeRelevance = this.offsetInEvents ? 30 : 0;
        this.addKeywords(result, Arrays.asList(Constants.event_keywords), componentRelevance, scopeRelevance);
        componentRelevance = this.componentType == IDom.Type.Machine ? 50 : 0;
        scopeRelevance = this.offsetInEvents ? 20 : 30;
        this.addKeywords(result, Arrays.asList(Constants.machine_keywords), componentRelevance, scopeRelevance);
        componentRelevance = this.componentType == IDom.Type.Context ? 50 : 0;
        scopeRelevance = this.offsetInEvents ? 0 : 30;
        this.addKeywords(result, Arrays.asList(Constants.context_keywords), componentRelevance, scopeRelevance);
        proposals.addAll(result.values());
    }

    private void addKeywords(Map<String, ICompletionProposal> result, List<String> keywords, int componentRelevance, int scopeRelevance) {
        for (String keyword : keywords) {
            if (!keyword.startsWith(this.prefix)) continue;
            ICompletionProposal oldProposal = result.get(keyword);
            int relevance = componentRelevance + scopeRelevance;
            if (oldProposal != null) {
                EventBCompletionProposal evtBProp;
                int oldRelevance;
                if (!(oldProposal instanceof IRelevantProposal) || (oldRelevance = (evtBProp = (EventBCompletionProposal)oldProposal).getRelevance()) >= relevance) continue;
                evtBProp.changeRelevance(relevance - oldRelevance);
                continue;
            }
            EventBCompletionProposal proposal = new EventBCompletionProposal(keyword, this.region.getOffset(), this.prefix.length(), keyword.length(), null, keyword, null, "keyword '" + keyword + "'");
            proposal.changeRelevance(relevance);
            result.put(keyword, proposal);
        }
    }

    private void computeIdentifierProposals(List<ICompletionProposal> proposals) {
        if (this.dom == null || this.scopingDom == null || !"__dftl_partition_content_type".equals(this.contentType)) {
            return;
        }
        Set<String> identifiers = this.scopingDom.getIdentifiers();
        for (String ident : identifiers) {
            if (!ident.startsWith(this.prefix)) continue;
            IDom.IdentifierType type = this.scopingDom.getIdentifierType(ident);
            String description = this.createDescription(ident, type);
            Image image = this.getImage(type);
            EventBCompletionProposal proposal = new EventBCompletionProposal(ident, this.region.getOffset(), this.prefix.length(), ident.length(), image, ident, null, description);
            proposals.add(proposal);
            proposal.changeRelevance(100);
        }
    }

    private String createDescription(String ident, IDom.IdentifierType type) {
        StringBuffer description = new StringBuffer(ident);
        if (type != null) {
            switch (type) {
                case GlobalVariable: {
                    description.append(" : global variable");
                    break;
                }
                case LocalVariable: {
                    description.append(" : local variable");
                    break;
                }
                case Parameter: {
                    description.append(" : event parameter");
                    break;
                }
                case Constant: {
                    description.append(" : constant");
                    break;
                }
                case Set: {
                    description.append(" : carrier set");
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return description.toString();
    }

    private Image getImage(IDom.IdentifierType type) {
        if (type != null) {
            switch (type) {
                case GlobalVariable: 
                case Parameter: 
                case LocalVariable: {
                    return Images.getImage("Variable");
                }
                case Constant: {
                    return Images.getImage("Constant");
                }
                case Set: {
                    return Images.getImage("Carrier Set");
                }
            }
        }
        return null;
    }

    private int adjustOffset(ITextViewer viewer, int offset) {
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        return offset;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return new TemplateContextType(ContextType.Unkown.key);
    }

    protected Image getImage(Template template) {
        return Images.getImage("Template", "icons/template_obj.gif");
    }

    private Template[] getTemplates() {
        if (this.templateStore == null) {
            this.templateStore = TextEditorPlugin.getPlugin().getTemplateStore();
        }
        return this.templateStore.getTemplates(null);
    }

    protected Template[] getTemplates(String contextTypeId) {
        return this.getTemplates();
    }

    protected int getRelevance(Template template, String prefix) {
        int relevance;
        String id;
        block14: {
            block13: {
                id = template.getContextTypeId();
                if (ContextType.Anywhere.key.equals(id)) {
                    return 90;
                }
                relevance = 0;
                if (this.componentType == null) break block13;
                switch (this.componentType) {
                    case Machine: {
                        if (ContextType.Machine.key.equals(id) || ContextType.Events.key.equals(id)) {
                            relevance += 50;
                            break;
                        }
                        break block14;
                    }
                    case Context: {
                        if (ContextType.Context.key.equals(id)) {
                            relevance += 50;
                            break;
                        }
                        break block14;
                    }
                    case Event: {
                        break;
                    }
                    case Formula: {
                        break;
                    }
                    case Unknown: {
                        break;
                    }
                }
                break block14;
            }
            relevance += 50;
        }
        if (ContextType.Events.key.equals(id)) {
            if (this.offsetInEvents) {
                relevance += 40;
            }
        } else {
            relevance += 40;
        }
        return relevance;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum ContextType {
        Unkown("org.eventb.texteditor.unknown"),
        Anywhere("org.eventb.texteditor.anywhere"),
        Machine("org.eventb.texteditor.machine"),
        Context("org.eventb.texteditor.context"),
        Events("org.eventb.texteditor.events");

        public final String key;

        private ContextType(String key) {
            this.key = key;
        }
    }

    private final class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            int rel1 = this.getRelevance(o1);
            int rel2 = this.getRelevance(o2);
            int diff = rel2 - rel1;
            if (diff != 0 && rel1 >= 0 && rel2 >= 0) {
                return diff;
            }
            return o1.getDisplayString().toLowerCase().compareTo(o2.getDisplayString().toLowerCase());
        }

        private int getRelevance(ICompletionProposal o) {
            if (o instanceof IRelevantProposal) {
                return ((IRelevantProposal)o).getRelevance();
            }
            return -1;
        }
    }
}

