/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texttools.prettyprint.PrettyPrinter;

public class FormatHandler
extends AbstractHandler {
    public FormatHandler() {
        this.setBaseEnabled(true);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor != null && activeEditor instanceof EventBTextEditor) {
            try {
                this.formatContent((EventBTextEditor)activeEditor);
            }
            catch (CoreException e) {
                throw new ExecutionException("Content formatting failed", (Throwable)e);
            }
        }
        return null;
    }

    private void formatContent(EventBTextEditor editor) throws CoreException {
        if (!this.hasSyntaxErrors(editor)) {
            IDocument document;
            int cursorOffset = editor.getCursorOffset();
            IEditorInput editorInput = editor.getEditorInput();
            DomManager.ParseResult parseResult = TextEditorPlugin.getDomManager().getLastParseResult(editorInput);
            if (parseResult != null && (document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null) {
                String remberedContent = document.get();
                String lineDelimiter = document.getLegalLineDelimiters()[0];
                int i = 1;
                while (i < document.getLegalLineDelimiters().length) {
                    if (document.getLegalLineDelimiters()[i].equals("\n")) {
                        lineDelimiter = "\n";
                        break;
                    }
                    ++i;
                }
                StringBuilder buffer = new StringBuilder();
                new PrettyPrinter(buffer, lineDelimiter, null).prettyPrint(parseResult.astRoot);
                String newContent = buffer.toString();
                if (!newContent.equals(remberedContent)) {
                    document.set(newContent);
                    editor.setCurserOffset(cursorOffset);
                }
            }
        }
    }

    private boolean hasSyntaxErrors(EventBTextEditor editor) throws CoreException {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IMarker[] markers = fileInput.getFile().findMarkers("org.eventb.texteditor.ui.syntaxerror", true, 2);
            return markers.length > 0;
        }
        return true;
    }
}

