/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eventb.texteditor.ui.Images;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.editor.DocumentProvider;
import org.eventb.texteditor.ui.editor.GotoMarker;
import org.eventb.texteditor.ui.editor.ModelChangeListener;
import org.eventb.texteditor.ui.editor.SourceViewerConfiguration;
import org.eventb.texteditor.ui.outline.OutlinePage;
import org.eventb.texteditor.ui.outline.RevealSelectionListener;
import org.eventb.texteditor.ui.reconciler.EventBPresentationReconciler;
import org.eventb.texttools.PersistenceHelper;
import org.eventb.texttools.TextToolsPlugin;

public class EventBTextEditor
extends TextEditor
implements IGotoMarker {
    public static final String CONTENT_FORMAT = "ContentFormat";
    public static final String CONTENT_ASSIST_PROPOSAL = "ContentAssistProposal";
    private GotoMarker gotoMarkerAdapter;
    private IContentOutlinePage contentOutlinePage;
    private Resource resource;
    private ModelChangeListener modelChangeListener;
    private AdapterFactoryEditingDomain editingDomain;
    private boolean isCurrentlySaving = false;
    private EventBPresentationReconciler presentationReconciler;
    private final IPartListener activeListener = new ActivateListener();
    private boolean resourceChangedWhileDirty;
    private boolean inLinkedMode = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.getPage().addPartListener(this.activeListener);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider((IDocumentProvider)new DocumentProvider(this));
        SourceViewerConfiguration viewerConfiguration = new SourceViewerConfiguration(this, this.getPreferenceStore());
        this.presentationReconciler = (EventBPresentationReconciler)viewerConfiguration.getPresentationReconciler(this.getSourceViewer());
        this.setSourceViewerConfiguration((org.eclipse.jface.text.source.SourceViewerConfiguration)viewerConfiguration);
        this.showChangeInformation(false);
        this.setEditorContextMenuId("#texteditor.context.menu");
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(TextEditorPlugin.getPlugin().getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(CONTENT_ASSIST_PROPOSAL, (IAction)action);
        this.markAsStateDependentAction(CONTENT_ASSIST_PROPOSAL, true);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IEditorInput oldInput = this.getEditorInput();
        super.doSetInput(input);
        this.resource = null;
        this.registerChangeListener(oldInput, this.getEditorInput());
        this.presentationReconciler.setInputResource(this.getResource());
        this.adjustLabels();
    }

    private void registerChangeListener(IEditorInput oldInput, IEditorInput editorInput) {
        if (this.modelChangeListener != null && oldInput instanceof IFileEditorInput) {
            ((IFileEditorInput)oldInput).getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.modelChangeListener);
        }
        if (editorInput instanceof IFileEditorInput) {
            this.modelChangeListener = new ModelChangeListener(this);
            ((IFileEditorInput)editorInput).getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this.modelChangeListener);
        }
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
            IProject project = fileInput.getFile().getProject();
            this.editingDomain = TextToolsPlugin.getDefault().getResourceManager().getEditingDomain(project);
        }
        return this.editingDomain;
    }

    protected String[] collectContextMenuPreferencePages() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.collectContextMenuPreferencePages()));
        result.add("org.eventb.texteditor.ui.preferences");
        result.add("org.eventb.texteditor.ui.preferences.HighlightingPreferencePage");
        result.add("org.eventb.texteditor.ui.preferences.TemplatePreferences");
        return result.toArray(new String[result.size()]);
    }

    protected LineChangeHover createChangeHover() {
        return null;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("'SaveAs' is not allowed for the Event-B text editor.");
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.activeListener);
        this.registerChangeListener(this.getEditorInput(), null);
        super.dispose();
    }

    public Resource getResource() {
        IEditorInput editorInput;
        if (this.resource == null && (editorInput = this.getEditorInput()) != null) {
            AdapterFactoryEditingDomain editingDomain = this.getEditingDomain();
            URI inputUri = EditUIUtil.getURI((IEditorInput)editorInput);
            this.resource = editingDomain.getResourceSet().getResource(inputUri, true);
        }
        return this.resource;
    }

    public StyledText getTextWidget() {
        return this.getSourceViewer().getTextWidget();
    }

    public void insert(final String symbol, final boolean correctCursorPosition) {
        if (symbol != null && symbol.length() > 0) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IDocument document = EventBTextEditor.this.getDocumentProvider().getDocument((Object)EventBTextEditor.this.getEditorInput());
                    int offset = EventBTextEditor.this.getCursorOffset();
                    try {
                        document.replace(offset, 0, symbol);
                        if (correctCursorPosition) {
                            EventBTextEditor.this.setCurserOffset(offset + symbol.length());
                        }
                    }
                    catch (BadLocationException e) {
                        TextEditorPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eventb.texteditor.ui", "Could not insert text into Event-B text editor.", (Throwable)e));
                    }
                }
            });
        }
    }

    public int getCursorOffset() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            return EventBTextEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)sourceViewer.getTextWidget().getCaretOffset());
        }
        return 0;
    }

    public void setCurserOffset(int offsetInDocument) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            int widgetOffset = EventBTextEditor.modelOffset2WidgetOffset((ISourceViewer)sourceViewer, (int)offsetInDocument);
            StyledText textWidget = sourceViewer.getTextWidget();
            textWidget.setCaretOffset(widgetOffset);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return this.getGotoMarker();
        }
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    private Object getGotoMarker() {
        if (this.gotoMarkerAdapter == null) {
            this.gotoMarkerAdapter = new GotoMarker(this);
        }
        return this.gotoMarkerAdapter;
    }

    private IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new OutlinePage(this);
            this.contentOutlinePage.addSelectionChangedListener((ISelectionChangedListener)new RevealSelectionListener(this));
        }
        return this.contentOutlinePage;
    }

    public void updateIsDirty() {
        this.firePropertyChange(257);
    }

    public void setIsSaving(boolean state) {
        this.isCurrentlySaving = state;
    }

    public boolean isSaving() {
        return this.isCurrentlySaving;
    }

    public final int widgetOffset2ModelOffset(int widgetOffset) {
        return EventBTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)widgetOffset);
    }

    public final int modelOffset2WidgetOffset(int modelOffset) {
        return EventBTextEditor.modelOffset2WidgetOffset((ISourceViewer)this.getSourceViewer(), (int)modelOffset);
    }

    public void changeWhileDirty() {
        this.resourceChangedWhileDirty = true;
    }

    public void setInLinkedMode(boolean linkedMode) {
        this.inLinkedMode = linkedMode;
    }

    public boolean isInLinkedMode() {
        return this.inLinkedMode;
    }

    private void adjustLabels() {
        IEditorInput input = this.getEditorInput();
        if (input != null) {
            URI inputUri = EditUIUtil.getURI((IEditorInput)input);
            Resource resource = this.getEditingDomain().getResourceSet().getResource(inputUri, true);
            this.changeImage(resource);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                String name = file.getName();
                name = name.substring(0, name.length() - file.getFileExtension().length() - 1);
                this.setPartName(name);
            }
        }
    }

    private void changeImage(Resource resource) {
        EClass componentType = PersistenceHelper.getComponentType((Resource)resource);
        if (componentType != null) {
            String packageNsURI = componentType.getEPackage().getNsURI();
            if (packageNsURI.equals("http://emf.eventb.org/models/core/machine/2014")) {
                this.setTitleImage(Images.getImage("Machine"));
            } else if (packageNsURI.equals("http://emf.eventb.org/models/core/context/2014")) {
                this.setTitleImage(Images.getImage("Context"));
            }
        }
    }

    private void handleActive() {
        if (this.resourceChangedWhileDirty) {
            try {
                this.handleEditorInputChanged();
            }
            finally {
                this.resourceChangedWhileDirty = false;
            }
        }
        this.presentationReconciler.reconcilePresentation();
    }

    class ActivateListener
    implements IPartListener {
        ActivateListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == EventBTextEditor.this) {
                EventBTextEditor.this.handleActive();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

