/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.formulas.BFormula;
import org.eventb.emf.formulas.BoundIdentifierExpression;
import org.eventb.emf.formulas.IdentifierExpression;
import org.eventb.texteditor.ui.build.dom.AbstractDom;
import org.eventb.texteditor.ui.build.dom.IDom;

public class FormulaDom
extends AbstractDom {
    private final BFormula formula;
    private final Map<String, IdentifierExpression> freeIdentifiers = new HashMap<String, IdentifierExpression>();
    private final Map<String, BoundIdentifierExpression> boundIdentifiers = new HashMap<String, BoundIdentifierExpression>();

    public FormulaDom(BFormula formula, IDom parent) {
        super(IDom.Type.Event, parent);
        this.formula = formula;
    }

    @Override
    public EventBObject getEventBElement() {
        return this.formula;
    }

    @Override
    protected synchronized Set<String> doGetIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getBoundIdentifiers().keySet());
        result.addAll(this.getFreeIdentifiers().keySet());
        return result;
    }

    @Override
    protected IDom.IdentifierType doGetIdentifierType(String identifier) {
        if (this.boundIdentifiers.containsKey(identifier)) {
            return IDom.IdentifierType.LocalVariable;
        }
        return null;
    }

    public Map<String, IdentifierExpression> getFreeIdentifiers() {
        return this.freeIdentifiers;
    }

    public void addFreeIdentifier(IdentifierExpression expression) {
        this.freeIdentifiers.put(expression.getName(), expression);
    }

    public Map<String, BoundIdentifierExpression> getBoundIdentifiers() {
        return this.boundIdentifiers;
    }

    public void addBoundIdentifier(BoundIdentifierExpression expression) {
        this.boundIdentifiers.put(expression.getName(), expression);
    }
}

