/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.outline;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.StyledString;
import org.eventb.emf.core.EventBNamed;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Invariant;
import org.eventb.emf.core.machine.Machine;
import org.eventb.emf.core.machine.Variant;
import org.eventb.emf.core.machine.util.MachineSwitch;
import org.eventb.texteditor.ui.outline.LabelHelper;

public class MachineLabelSwitch
extends MachineSwitch<StyledString> {
    public StyledString caseEventBNamed(EventBNamed object) {
        return LabelHelper.getStyledName(object.getName());
    }

    public StyledString caseMachine(Machine object) {
        EList seesNames;
        StyledString result = LabelHelper.getStyledName(object.getName());
        EList refinesNames = object.getRefinesNames();
        if (refinesNames.size() > 0) {
            LabelHelper.appendAttrDelim(result);
            result.append("refines ", LabelHelper.ATTRIBUTE_STYLER);
            result.append(LabelHelper.joinEList(refinesNames), LabelHelper.ATTRIBUTE_STYLER);
        }
        if ((seesNames = object.getSeesNames()).size() > 0) {
            LabelHelper.appendAttrDelim(result);
            result.append("sees ", LabelHelper.ATTRIBUTE_STYLER);
            result.append(LabelHelper.joinEList(seesNames), LabelHelper.ATTRIBUTE_STYLER);
        }
        return result;
    }

    public StyledString caseInvariant(Invariant object) {
        StyledString result = LabelHelper.getStyledName(object.getName());
        if (object.isTheorem()) {
            LabelHelper.appendAttrDelim(result);
            result.append("theorem", LabelHelper.ATTRIBUTE_STYLER);
        }
        return result;
    }

    public StyledString caseVariant(Variant object) {
        return LabelHelper.getStyledName("Variant");
    }

    public StyledString caseEvent(Event object) {
        StyledString result = LabelHelper.getStyledName(object.getName());
        if (object.getParameters().size() > 0) {
            String paramString = LabelHelper.joinEList(object.getParameters());
            result.append(" (" + paramString + ")");
        }
        EList refinesNames = object.getRefinesNames();
        if (object.isExtended()) {
            LabelHelper.appendAttrDelim(result);
            result.append("extends ", LabelHelper.ATTRIBUTE_STYLER);
            if (refinesNames.size() > 0) {
                result.append((String)refinesNames.get(0), LabelHelper.ATTRIBUTE_STYLER);
            } else {
                result.append("?", LabelHelper.ATTRIBUTE_STYLER);
            }
        } else if (refinesNames.size() > 0) {
            LabelHelper.appendAttrDelim(result);
            result.append("refines ", LabelHelper.ATTRIBUTE_STYLER);
            result.append(LabelHelper.joinEList(refinesNames), LabelHelper.ATTRIBUTE_STYLER);
        }
        return result;
    }
}

