/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.Builder;
import org.eventb.texteditor.ui.build.dom.DomManager;
import org.eventb.texteditor.ui.editor.AnnotationModel;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texteditor.ui.editor.TrimLinesAction;
import org.eventb.texteditor.ui.reconciler.partitioning.PartitionScanner;
import org.eventb.texteditor.ui.reconciler.partitioning.Partitioner;
import org.eventb.texttools.PersistenceHelper;

public class DocumentProvider
extends FileDocumentProvider {
    private final EventBTextEditor editor;

    public DocumentProvider(EventBTextEditor editor) {
        this.editor = editor;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new AnnotationModel((IResource)input.getFile(), this.getResourceForElement((IEditorInput)input));
        }
        return super.createAnnotationModel(element);
    }

    protected void setupDocument(Object element, IDocument document) {
        IDocumentPartitioner oldPartitioner = document.getDocumentPartitioner();
        if (oldPartitioner != null) {
            oldPartitioner.disconnect();
        }
        Partitioner partitioner = new Partitioner(new PartitionScanner(), PartitionScanner.CONTENT_TYPES);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        partitioner.connect(document, true);
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(final Object element) throws CoreException {
        final AbstractDocumentProvider.ElementInfo info = super.createElementInfo(element);
        if (info != null && element instanceof IEditorInput) {
            IDocument document = info.fDocument;
            document.addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    boolean newState = DocumentProvider.this.isDirty(info, (IEditorInput)element);
                    if (info.fCanBeSaved != newState) {
                        info.fCanBeSaved = newState;
                        DocumentProvider.this.editor.updateIsDirty();
                    }
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
        }
        return info;
    }

    private boolean isDirty(AbstractDocumentProvider.ElementInfo info, IEditorInput element) {
        String currentInput = info.fDocument.get();
        String savedInput = PersistenceHelper.getTextAnnotation((Resource)this.getResourceForElement(element));
        return currentInput != null && !currentInput.equals(savedInput);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        InputStream stream;
        Resource resource = this.getResourceForElement(editorInput);
        String lineDelimiter = document.getLegalLineDelimiters()[0];
        int i = 1;
        while (i < document.getLegalLineDelimiters().length) {
            if (document.getLegalLineDelimiters()[i].equals("\n")) {
                lineDelimiter = "\n";
                break;
            }
            ++i;
        }
        try {
            stream = this.createContentStream(resource, encoding, lineDelimiter);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            this.setDocumentContent(document, stream, encoding);
            this.reconcileContent(resource, document, null);
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    protected ISchedulingRule getSaveRule(Object element) {
        if (element instanceof IFileEditorInput) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!(element instanceof IEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eventb.texteditor.ui", "Unsupported target element: " + element));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Saving", (int)4);
        this.editor.setIsSaving(true);
        Resource resource = this.getResourceForElement((IEditorInput)element);
        int newCursorOffset = this.trimLines(document, subMonitor.newChild(1));
        this.reconcileContent(resource, document, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.worked(1);
        PersistenceHelper.saveText((Resource)resource, (boolean)overwrite, (IProgressMonitor)subMonitor.newChild(1));
        this.editor.setIsSaving(false);
        this.editor.setCurserOffset(newCursorOffset);
        this.editor.selectAndReveal(newCursorOffset, 0);
    }

    private void reconcileContent(Resource resource, IDocument document, IProgressMonitor m) {
        DomManager.ParseResult lastParseResult;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)2);
        EventBNamedCommentedComponentElement astRoot = null;
        Builder builder = new Builder();
        builder.run(this.editor, document, (IProgressMonitor)monitor.newChild(1));
        if (builder.wasSuccessful() && (lastParseResult = TextEditorPlugin.getDomManager().getLastParseResult(this.editor.getEditorInput())) != null) {
            astRoot = (EventBNamedCommentedComponentElement)lastParseResult.astRoot;
        }
        if (astRoot != null) {
            PersistenceHelper.mergeRootElement((Resource)resource, astRoot, (IProgressMonitor)monitor.newChild(1));
        } else {
            try {
                PersistenceHelper.addTextAnnotation((Resource)resource, (String)document.get(), (long)System.currentTimeMillis());
            }
            catch (CoreException e) {
                TextEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eventb.texteditor.ui", "Cannot store text representation into Resource", (Throwable)e));
            }
            monitor.worked(1);
        }
    }

    private int trimLines(IDocument document, SubMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        int cursorOffset = this.editor.getCursorOffset();
        try {
            int removedChars = TrimLinesAction.trimLines(document, 0, document.getNumberOfLines() - 1, (IProgressMonitor)subMonitor.newChild(1));
            return (cursorOffset -= removedChars) < document.getLength() ? cursorOffset : document.getLength() - 1;
        }
        catch (BadLocationException badLocationException) {
            return cursorOffset;
        }
    }

    private Resource getResourceForElement(IEditorInput editorInput) {
        URI inputUri = EditUIUtil.getURI((IEditorInput)editorInput);
        Resource resource = this.editor.getEditingDomain().getResourceSet().getResource(inputUri, true);
        return resource;
    }

    private InputStream createContentStream(Resource resource, String encoding, String lineBreak) throws CoreException, IOException {
        return new ByteArrayInputStream(PersistenceHelper.loadText((Resource)resource, (String)lineBreak).getBytes(encoding));
    }
}

