/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.context.CarrierSet;
import org.eventb.emf.core.context.Constant;
import org.eventb.emf.core.machine.Machine;
import org.eventb.emf.core.machine.Variable;
import org.eventb.texteditor.ui.build.dom.AbstractComponentDom;
import org.eventb.texteditor.ui.build.dom.ContextDom;
import org.eventb.texteditor.ui.build.dom.IComponentDom;
import org.eventb.texteditor.ui.build.dom.IDom;

public class MachineDom
extends AbstractComponentDom {
    private Machine machine;
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    private final List<MachineDom> refinedMachines = new LinkedList<MachineDom>();
    private final List<ContextDom> seenContexts = new LinkedList<ContextDom>();

    MachineDom(Resource resource, Machine machine) {
        super(IDom.Type.Machine, null, resource);
        this.machine = machine;
    }

    @Override
    protected synchronized void doReset() {
        this.refinedMachines.clear();
        this.seenContexts.clear();
        this.variables.clear();
    }

    @Override
    protected synchronized Set<String> doGetIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getVariables(true).keySet());
        result.addAll(this.getConstants().keySet());
        result.addAll(this.getSets().keySet());
        return result;
    }

    @Override
    protected synchronized IDom.IdentifierType doGetIdentifierType(String identifier) {
        if (this.variables.containsKey(identifier)) {
            return IDom.IdentifierType.GlobalVariable;
        }
        if (this.getConstants().containsKey(identifier)) {
            return IDom.IdentifierType.Constant;
        }
        if (this.getSets().containsKey(identifier)) {
            return IDom.IdentifierType.Set;
        }
        return null;
    }

    @Override
    public Set<IComponentDom> getReferencedDoms(boolean transitive) {
        List<ContextDom> contexts = this.getSeenContexts();
        List<MachineDom> machines = this.getRefinedMachines();
        HashSet<IComponentDom> result = new HashSet<IComponentDom>(contexts);
        result.addAll(machines);
        if (transitive) {
            for (IComponentDom iComponentDom : contexts) {
                result.addAll(iComponentDom.getReferencedDoms(transitive));
            }
            for (IComponentDom iComponentDom : machines) {
                result.addAll(iComponentDom.getReferencedDoms(false));
            }
        }
        return result;
    }

    public synchronized Map<String, Variable> getVariables(boolean includeInherited) {
        this.checkInitialization();
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        if (includeInherited) {
            for (MachineDom dom : this.getRefinedMachines()) {
                result.putAll(dom.getVariables(false));
            }
        }
        result.putAll(this.variables);
        return result;
    }

    public synchronized Map<String, Constant> getConstants() {
        this.checkInitialization();
        HashMap<String, Constant> result = new HashMap<String, Constant>();
        for (ContextDom dom : this.getSeenContexts()) {
            result.putAll(dom.getConstants(true));
        }
        return result;
    }

    public synchronized Map<String, CarrierSet> getSets() {
        this.checkInitialization();
        HashMap<String, CarrierSet> result = new HashMap<String, CarrierSet>();
        for (ContextDom dom : this.getSeenContexts()) {
            result.putAll(dom.getSets(true));
        }
        return result;
    }

    public synchronized List<MachineDom> getRefinedMachines() {
        this.checkInitialization();
        return this.refinedMachines;
    }

    public synchronized List<ContextDom> getSeenContexts() {
        this.checkInitialization();
        return this.seenContexts;
    }

    synchronized void addVariable(Variable var) {
        this.variables.put(var.getName(), var);
    }

    synchronized void addRefinedMachine(MachineDom dom) {
        this.refinedMachines.add(dom);
    }

    synchronized void addSeenContext(ContextDom dom) {
        this.seenContexts.add(dom);
    }

    @Override
    public synchronized EventBObject getEventBElement() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }
}

