/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.dom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.emf.core.EventBObject;
import org.eventb.emf.core.machine.Event;
import org.eventb.emf.core.machine.Parameter;
import org.eventb.texteditor.ui.build.dom.AbstractDom;
import org.eventb.texteditor.ui.build.dom.IDom;
import org.eventb.texteditor.ui.build.dom.MachineDom;

public class EventDom
extends AbstractDom {
    private final Event event;
    private final Map<String, Event> refinedEvents = new HashMap<String, Event>();
    private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

    public EventDom(Event event, MachineDom parent) {
        super(IDom.Type.Event, parent);
        this.event = event;
    }

    @Override
    protected synchronized Set<String> doGetIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getParameters().keySet());
        return result;
    }

    @Override
    protected IDom.IdentifierType doGetIdentifierType(String identifier) {
        if (this.parameters.containsKey(identifier)) {
            return IDom.IdentifierType.Parameter;
        }
        return null;
    }

    @Override
    public EventBObject getEventBElement() {
        return this.event;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void addAllParameters(List<Parameter> params) {
        for (Parameter parameter : params) {
            this.parameters.put(parameter.getName(), parameter);
        }
    }

    public Map<String, Event> getRefinedEvents() {
        return this.refinedEvents;
    }

    public void addAllRefinedEvent(List<Event> events) {
        for (Event evt : events) {
            this.refinedEvents.put(evt.getName(), evt);
        }
    }
}

