/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.ast;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eventb.core.ast.ASTProblem;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.emf.core.EventBObject;
import org.eventb.texteditor.ui.MarkerHelper;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.ast.FormulaExceptionWrapperDiagnostic;
import org.eventb.texttools.TextPositionUtil;
import org.eventb.texttools.formulas.FormulaParseException;
import org.eventb.texttools.formulas.FormulaResolver;
import org.eventb.texttools.model.texttools.TextRange;

public class FormulasResolver {
    private static final MarkerHelper markerHelper = new MarkerHelper("org.eventb.texteditor.ui.syntaxerror");

    public static void resolveFormulas(Resource resource, EventBNamedCommentedComponentElement astRoot, IDocument document, boolean markErrors) {
        String projectName = resource.getURI().segment(1);
        List exceptions = FormulaResolver.resolveAllFormulas((String)projectName, (EventBNamedCommentedComponentElement)astRoot);
        if (markErrors && exceptions.size() > 0) {
            markerHelper.deleteMarkers(resource, "org.rodinp.core.problem", true, 0);
            FormulasResolver.markErrors(exceptions, resource, document);
        }
    }

    private static void markErrors(List<FormulaParseException> exceptions, Resource resource, IDocument document) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, "org.eventb.texteditor.ui", 0, "Error occured when parsing the formulas", new Object[]{resource});
        for (FormulaParseException ex : exceptions) {
            String inputFormula = ex.getFormula();
            TextRange range = TextPositionUtil.getInternalPosition((EventBObject)ex.getEmfObject(), (String)inputFormula);
            int offset = range.getOffset();
            List problems = ex.getAstProblems();
            for (ASTProblem problem : problems) {
                diagnostic.add(FormulasResolver.createChildDiagnostic(problem, offset, inputFormula, document, resource));
            }
        }
        try {
            markerHelper.createMarkers((Diagnostic)diagnostic);
        }
        catch (CoreException e) {
            TextEditorPlugin.INSTANCE.log((Object)e);
        }
    }

    private static Diagnostic createChildDiagnostic(ASTProblem problem, int offset, String inputFormula, IDocument document, Resource resource) {
        FormulaExceptionWrapperDiagnostic wrappedException = new FormulaExceptionWrapperDiagnostic(problem, offset, document);
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, "org.eventb.texteditor.ui", 0, wrappedException.getMessage(), new Object[]{resource, wrappedException});
        return diagnostic;
    }
}

