/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.texteditor.ui.build.ast;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eventb.emf.core.EventBElement;
import org.eventb.emf.core.EventBNamedCommentedComponentElement;
import org.eventb.texteditor.ui.MarkerHelper;
import org.eventb.texteditor.ui.TextEditorPlugin;
import org.eventb.texteditor.ui.build.IBuildPhase;
import org.eventb.texteditor.ui.build.ast.FormulaTranslator;
import org.eventb.texteditor.ui.build.ast.FormulasResolver;
import org.eventb.texteditor.ui.build.ast.ParseExceptionWrapperDiagnostic;
import org.eventb.texteditor.ui.editor.EventBTextEditor;
import org.eventb.texttools.ParseException;
import org.eventb.texttools.Parser;
import org.eventb.texttools.PersistenceHelper;

public class AstBuilder
implements IBuildPhase {
    private final FormulaTranslator translator = new FormulaTranslator();
    private final Parser textParser = new Parser();
    private boolean successful;

    @Override
    public boolean isUIPhase() {
        return false;
    }

    @Override
    public boolean canFail() {
        return true;
    }

    @Override
    public boolean wasSuccessful() {
        return this.successful;
    }

    @Override
    public void run(EventBTextEditor editor, Resource resource, IDocument document, IProgressMonitor monitor) {
        this.successful = false;
        EventBNamedCommentedComponentElement astRoot = this.build(resource, document, true, editor, monitor);
        if (astRoot != null) {
            String docContent = document.get();
            TextEditorPlugin.getDomManager().storeParseResult(editor.getEditorInput(), docContent, astRoot);
            this.successful = true;
        } else {
            this.successful = false;
        }
    }

    private EventBNamedCommentedComponentElement build(Resource resource, IDocument document, boolean markFormulaErrors, EventBTextEditor editor, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        EventBNamedCommentedComponentElement astRoot = this.createAST(resource, document);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return astRoot;
        }
        if (astRoot != null) {
            monitor.subTask("Translating formulas");
            this.translator.translateFormulas(astRoot, document, editor);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return null;
            }
            monitor.subTask("Resolving formulas");
            FormulasResolver.resolveFormulas(resource, astRoot, document, markFormulaErrors);
            monitor.worked(1);
            PersistenceHelper.addTextAnnotation((EventBElement)astRoot, (String)document.get(), (long)System.currentTimeMillis());
        }
        return astRoot;
    }

    private EventBNamedCommentedComponentElement createAST(Resource resource, IDocument document) {
        MarkerHelper helper = new MarkerHelper("org.eventb.texteditor.ui.syntaxerror");
        helper.deleteMarkers(resource, true, 2);
        EventBNamedCommentedComponentElement component = null;
        try {
            component = (EventBNamedCommentedComponentElement)this.textParser.parse(document);
        }
        catch (ParseException e) {
            ParseExceptionWrapperDiagnostic wrappedException = new ParseExceptionWrapperDiagnostic(document, e);
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, "org.eventb.texteditor.ui", 0, e.getLocalizedMessage(), new Object[]{resource, wrappedException});
            try {
                helper.createMarkers((Diagnostic)diagnostic);
            }
            catch (CoreException ex) {
                TextEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eventb.texteditor.ui", "Could not create markers", (Throwable)ex));
            }
        }
        return component;
    }
}

